package cn.schoolwow.quickhttp.domain.websocket;

import java.net.Socket;

public interface WebSocketClient extends AutoCloseable {
    /**
     * 发送文本帧
     * */
    void sendText(String text);

    /**
     * 发送二进制消息
     * */
    void sendBinary(byte[] data);

    /**
     * 发送数据帧
     * */
    void sendWebSocketFrame(WebSocketFrame webSocketFrame);

    /**
     * 接收文本帧
     * */
    String receiveText();

    /**
     * 接收二进制帧
     * */
    byte[] receiveBinary();

    /**
     * 发送ping帧
     * */
    void ping();

    /**
     * 接收数据帧
     * */
    WebSocketFrame receiveWebSocketFrame();

    /**
     * 关闭连接
     * */
    void close();

    /**
     * 获取当前状态
     * */
    WebSocketState getState();

    /**
     * 获取客户端套接字
     * */
    Socket getSocket();
}
