package cn.schoolwow.quickhttp.domain.websocket;

/**数据帧操作代码*/
public enum OPCode {
    /**延续分片*/
    ContinueFrame(0),
    /**文本帧*/
    TextFrame(1),
    /**二进制帧*/
    BinaryFrame(2),
    /**连接断开*/
    Close(8),
    /**Ping帧*/
    PingFrame(9),
    /**Pong帧*/
    PongFrame(10);

    public int value;

    OPCode(int value) {
        this.value = value;
    }

    /**获取操作代码*/
    public static OPCode getOPCode(int value){
        OPCode[] opCodes = OPCode.values();
        for(OPCode opCode:opCodes){
            if(opCode.value==value){
                return opCode;
            }
        }
        return null;
    }
}