package cn.schoolwow.quickhttp.domain.option;

import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.domain.execute.Response;

import java.io.IOException;

/**
 * http客户端事件监听
 */
public interface QuickHttpClientListener {
    /**
     * 在http请求发送之前
     *
     * @param request http请求信息
     * @return 返回true继续执行请求,否则取消执行
     */
    boolean beforeExecute(Request request) throws IOException;

    /**
     * http请求成功以后
     *
     * @param request  请求信息
     * @param response 响应信息
     */
    void executeSuccess(Request request, Response response) throws IOException;

    /**
     * http请求成功以后
     *
     * @param request 请求信息
     * @param e       异常信息
     */
    void executeFail(Request request, Exception e) throws IOException;
}
