package cn.schoolwow.quickhttp.domain.option;

import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.domain.execute.Response;

import java.io.IOException;

/**
 * http异步调用回调接口
 */
public interface AsyncExecuteHttpListener {
    /**
     * http请求成功以后
     *
     * @param request  请求信息
     * @param response 响应信息
     */
    void executeSuccess(Request request, Response response) throws IOException;

    /**
     * http请求成功以后
     *
     * @param request 请求信息
     * @param e       异常信息
     */
    void executeFail(Request request, Exception e) throws IOException;
}
