package cn.schoolwow.quickhttp.domain.execute;

import cn.schoolwow.quickhttp.module.request.cookie.RequestCookie;
import cn.schoolwow.quickhttp.module.request.data.RequestData;
import cn.schoolwow.quickhttp.module.request.execute.kit.RequestExecute;
import cn.schoolwow.quickhttp.module.request.header.RequestHeader;
import cn.schoolwow.quickhttp.module.request.option.kit.RequestOption;
import cn.schoolwow.quickhttp.module.request.url.kit.RequestUrl;

public interface Request extends Cloneable, RequestUrl,
        RequestHeader,
        RequestCookie,
        RequestData,
        RequestExecute,
        RequestOption {
    enum UserAgent {
        CHROME("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36"), ANDROID("Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Mobile Safari/537.36"), MAC("User-Agent, Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36");

        public final String userAgent;

        UserAgent(String userAgent) {
            this.userAgent = userAgent;
        }
    }

    enum ContentType {
        MULTIPART_FORMDATA("multipart/form-data"),
        APPLICATION_JSON("application/json"),
        APPLICATION_X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded");

        public String value;

        ContentType(String value) {
            this.value = value;
        }

        public static ContentType getInstanceByValue(String value){
            ContentType[] contentTypes = ContentType.values();
            for(ContentType contentType:contentTypes){
                if(contentType.value.equalsIgnoreCase(value)){
                    return contentType;
                }
            }
            return null;
        }
    }

    enum StreamingMode {
        Chunked,FixedLength;
    }

    enum Method {
        GET(false), POST(true), PUT(true), DELETE(false), PATCH(true), HEAD(false), OPTIONS(false), TRACE(false);

        private final boolean hasBody;

        Method(boolean hasBody) {
            this.hasBody = hasBody;
        }

        public final boolean hasBody() {
            return hasBody;
        }
    }

}
