package cn.schoolwow.quickhttp.domain.execute;

import org.jsoup.nodes.Document;

import java.io.InputStream;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * http响应上下文数据
 */
public class HttpResponseContext {
    /**
     * 状态码
     */
    public int statusCode;

    /**
     * 消息
     */
    public String statusMessage;

    /**
     * 状态行
     */
    public String statusLine;

    /**
     * 顶级域
     */
    public String topHost;

    /**
     * 编码格式
     */
    public String charset = "utf-8";

    /**
     * 响应体类型
     */
    public String contentType;

    /**
     * 响应体大小
     */
    public long contentLength = -1;

    /**
     * 响应体编码格式
     */
    public String contentEncoding;

    /**
     * 头部信息
     */
    public Map<String, List<String>> headerMap = new TreeMap<>(String.CASE_INSENSITIVE_ORDER);

    /**
     * 当前请求返回Cookie
     * */
    public List<HttpCookie> httpCookieList = new ArrayList<>();

    /**
     * 输入流
     */
    public transient InputStream inputStream;

    /**
     * 输入流字节数组
     */
    public transient byte[] body;

    /**
     * Document对象
     */
    public transient Document document;

}