package cn.schoolwow.quickhttp.domain.execute;

import cn.schoolwow.quickhttp.module.common.DataFileContext;
import cn.schoolwow.quickhttp.module.common.EventSource;

import java.io.Serializable;
import java.net.Proxy;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

/**
 * 用户请求数据
 */
public class HttpRequestOption implements Serializable {
    /**
     * 访问地址
     */
    public transient URL url;

    /**
     * 请求方法
     */
    public transient Request.Method method = Request.Method.GET;

    /**
     * Http代理
     */
    public transient Proxy proxy;

    /**
     * 请求编码
     */
    public String charset = "utf-8";

    /**
     * 系统判断请求类型
     */
    public String contentType;

    /**
     * 用户指定请求类型
     */
    public transient Request.ContentType userContentType;

    /**
     * 分隔符
     */
    public String boundary;

    /**
     * 头部信息
     */
    public Map<String, List<String>> headerMap = new TreeMap<>(String.CASE_INSENSITIVE_ORDER);

    /**
     * parameter信息
     */
    public Map<String, Object> parameterMap = new LinkedHashMap<>();

    /**
     * 表单信息
     */
    public Map<String, Object> dataMap = new LinkedHashMap<>();

    /**
     * 表单信息
     */
    public Map<String, List<DataFileContext>> dataFileMap = new HashMap<>();

    /**
     * 自定义请求体
     */
    public transient byte[] requestBody;

    /**
     * 连接超时(毫秒)
     */
    public int connectTimeoutMillis = 3000;

    /**
     * 读取超时(毫秒)
     */
    public int readTimeoutMillis = 5000;

    /**
     * 是否自动重定向
     */
    public boolean followRedirects = true;

    /**
     * 最大重定向次数
     */
    public int maxFollowRedirectTimes = 20;

    /**
     * 是否忽略http状态异常
     */
    public boolean ignoreHttpErrors;

    /**
     * 超时重试次数
     */
    public int retryTimes = 3;

    /**
     * EventSource处理函数
     */
    public transient Consumer<EventSource> eventSourceConsumer;

    /**
     * 额外属性
     * */
    public Map<String,Object> extraMap = new ConcurrentHashMap<>();

    /**
     * 是否添加Origin头部
     * */
    public boolean origin;

    public HttpRequestOption() {
        headerMap.put("Accept", Arrays.asList("application/json,text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9"));
        headerMap.put("Accept-Language", Arrays.asList("zh-cn,zh;q=0.9"));
        headerMap.put("User-Agent", Arrays.asList(Request.UserAgent.CHROME.userAgent));
    }
}