package cn.schoolwow.quickhttp.domain.client;

import cn.schoolwow.quickhttp.domain.execute.HttpExecuteEngine;
import cn.schoolwow.quickhttp.domain.option.ExecuteFlowListener;
import cn.schoolwow.quickhttp.domain.option.QuickHttpClientListener;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import java.net.Proxy;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * http客户端配置信息接口
 */
public interface QuickHttpClientConfig {
    /***
     * 是否开启调试模式
     */
    QuickHttpClientConfig debug(boolean debug);

    /***
     * 设置代理
     * @param proxy 代理对象
     */
    QuickHttpClientConfig proxy(Proxy proxy);

    /***
     * 设置代理
     * @param host 代理地址
     * @param port 代理端口
     */
    QuickHttpClientConfig proxy(String host, int port);

    /***
     * 设置代理认证信息
     * @param username 代理用户名
     * @param password 代理用户名密码
     */
    QuickHttpClientConfig proxyAuthority(String username, String password);

    /**
     * 设置连接超时时间(毫秒)
     *
     * @param connectTimeoutMillis 连接超时时间(毫秒),0表示不限制
     */
    QuickHttpClientConfig connectTimeout(int connectTimeoutMillis);

    /**
     * 设置读取超时时间(毫秒)
     *
     * @param readTimeoutMillis 读取超时时间(毫秒),0表示不限制
     **/
    QuickHttpClientConfig readTimeout(int readTimeoutMillis);

    /**
     * 是否自动重定向
     *
     * @param followRedirects 是否自动重新定定向.默认为true
     */
    QuickHttpClientConfig followRedirects(boolean followRedirects);

    /**
     * 指定最大重定向次数
     *
     * @param maxFollowRedirectTimes 最大重定向次数
     */
    QuickHttpClientConfig maxFollowRedirectTimes(int maxFollowRedirectTimes);

    /**
     * 是否忽略http错误(4xx和5xx响应码)
     *
     * @param ignoreHttpErrors 忽略http错误,默认为false
     */
    QuickHttpClientConfig ignoreHttpErrors(boolean ignoreHttpErrors);

    /**
     * <b>请求超时</b>时重试次数
     *
     * @param retryTimes 重试次数,默认为3次
     */
    QuickHttpClientConfig retryTimes(int retryTimes);

    /**
     * 设置HostnameVerifier
     *
     * @param hostnameVerifier sslSocketFactory
     */
    QuickHttpClientConfig hostnameVerifier(HostnameVerifier hostnameVerifier);

    /**
     * 设置SSLSocketFactory
     *
     * @param sslSocketFactory sslSocketFactory
     */
    QuickHttpClientConfig sslSocketFactory(SSLSocketFactory sslSocketFactory);

    /**
     * 设置异步执行时的线程池
     *
     * @param threadPoolExecutor 异步执行时的线程池
     */
    QuickHttpClientConfig threadPoolExecutor(ThreadPoolExecutor threadPoolExecutor);

    /**
     * 设置origin,执行http请求时会拼接到url前面
     *
     * @param origin origin信息
     */
    QuickHttpClientConfig origin(String origin);

    /**
     * 添加全局头部字段信息
     *
     * @param name  头部字段名称
     * @param value 头部字段值
     */
    QuickHttpClientConfig addHeader(String name, String value);

    /**
     * 设置全局头部字段信息
     *
     * @param name  头部字段名称
     * @param value 头部字段值
     */
    QuickHttpClientConfig setHeader(String name, String value);

    /**
     * 添加事件监听器
     *
     * @param quickHttpClientListener 事件监听对象
     */
    QuickHttpClientConfig quickHttpClientListener(QuickHttpClientListener quickHttpClientListener);

    /**
     * 执行流程监听器
     *
     * @param executeFlowListener 事件监听对象
     */
    QuickHttpClientConfig executeFlowListener(ExecuteFlowListener executeFlowListener);

    /**
     * 指定http执行引擎
     *
     * @param httpExecuteEngine 执行引擎
     */
    QuickHttpClientConfig httpExecuteEngine(HttpExecuteEngine httpExecuteEngine);
}
