package cn.schoolwow.quickhttp.domain.client;

import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketClient;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketClientConfig;

/**
 * http客户端接口
 */
public interface QuickHttpClient {
    /**
     * 客户端配置
     */
    QuickHttpClientConfig clientConfig();

    /**
     * Cookie管理
     */
    CookieOption cookieOption();

    /**
     * 访问url
     *
     * @param url 请求地址
     */
    Request connect(String url);

    /**
     * 访问websocket连接
     * @param url ws连接地址
     * */
    WebSocketClient connectWebSocket(String url);

    /**
     * 访问websocket连接
     * @param url ws连接地址
     * @param webSocketClientConfig 连接配置信息
     * */
    WebSocketClient connectWebSocket(String url, WebSocketClientConfig webSocketClientConfig);
}
