package cn.schoolwow.quickhttp;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.quickhttp.domain.client.QuickHttpClient;
import cn.schoolwow.quickhttp.domain.client.QuickHttpClientConfig;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketClient;
import cn.schoolwow.quickhttp.module.client.QuickHttpClientImpl;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketClientConfig;
import cn.schoolwow.quickhttp.module.webSocket.kit.WebSocketClientImpl;

public class QuickHttp {
    private static QuickFlow defaultHttpFlow = QuickFlowBuilder.newInstance();

    /**
     * 默认QuickHttp客户端
     */
    private static QuickHttpClient defaultQuickHttpClient = new QuickHttpClientImpl(defaultHttpFlow);

    /**
     * 客户端配置
     */
    public static QuickHttpClientConfig clientConfig() {
        return defaultQuickHttpClient.clientConfig();
    }

    /**
     * 访问url
     *
     * @param url 请求地址
     */
    public static Request connect(String url) {
        return defaultQuickHttpClient.connect(url);
    }

    public static WebSocketClient connectWebSocket(String url) {
        return new WebSocketClientImpl(url, null, defaultHttpFlow);
    }

    public static WebSocketClient connectWebSocket(String url, WebSocketClientConfig webSocketClientConfig) {
        return new WebSocketClientImpl(url, webSocketClientConfig, defaultHttpFlow);
    }

    /**
     * 获取默认的http客户端
     */
    public static QuickHttpClient defaultQuickHttpClient() {
        return defaultQuickHttpClient;
    }

    /**
     * 创建http客户端
     */
    public static QuickHttpClient newQuickHttpClient() {
        return new QuickHttpClientImpl(QuickFlowBuilder.newInstance());
    }

}
