/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.request;

import cn.schoolwow.quickhttp.domain.ClientConfig;
import cn.schoolwow.quickhttp.domain.RequestMeta;
import cn.schoolwow.quickhttp.listener.ResponseListener;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.request.RequestExecutor;
import cn.schoolwow.quickhttp.response.Response;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class RequestImpl
implements Request {
    private ClientConfig clientConfig;
    private RequestMeta requestMeta = new RequestMeta();

    public RequestImpl(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Override
    public Request url(URL url) {
        this.requestMeta.url = url;
        return this;
    }

    @Override
    public Request url(String url) {
        try {
            this.requestMeta.url = null != this.clientConfig.origin && !url.startsWith("http") ? new URL(this.clientConfig.origin + url) : new URL(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public Request method(String method) {
        for (Request.Method methodEnum : Request.Method.values()) {
            if (!methodEnum.name().equalsIgnoreCase(method)) continue;
            this.requestMeta.method = methodEnum;
            return this;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u6cd5!" + method);
    }

    @Override
    public Request method(Request.Method method) {
        this.requestMeta.method = method;
        return this;
    }

    @Override
    public Request basicAuth(String username, String password) {
        String encoded = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(Charset.forName(this.requestMeta.charset)));
        this.requestMeta.headerMap.put("Authorization", new ArrayList<String>(Arrays.asList("Basic " + encoded)));
        return this;
    }

    @Override
    public Request charset(String charset) {
        this.requestMeta.charset = charset;
        return this;
    }

    @Override
    public Request userAgent(String userAgent) {
        this.requestMeta.headerMap.put("User-Agent", new ArrayList<String>(Arrays.asList(userAgent)));
        return this;
    }

    @Override
    public Request userAgent(Request.UserAgent userAgent) {
        this.requestMeta.headerMap.put("User-Agent", new ArrayList<String>(Arrays.asList(userAgent.userAgent)));
        return this;
    }

    @Override
    public Request referrer(String referrer) {
        this.requestMeta.headerMap.put("Referer", new ArrayList<String>(Arrays.asList(referrer)));
        return this;
    }

    @Override
    public Request contentType(String contentType) {
        this.requestMeta.contentType = contentType;
        return this;
    }

    @Override
    public Request contentType(Request.ContentType contentType) {
        this.requestMeta.userContentType = contentType;
        return this;
    }

    @Override
    public Request ajax() {
        URL url = this.requestMeta.url;
        return this.setHeader("X-Requested-With", "XMLHttpRequest").setHeader("Origin", url.getProtocol() + "://" + url.getHost());
    }

    @Override
    public Request ranges(long start, long end) {
        return this.setHeader("Range", "bytes=" + start + "-" + (end > 0L ? Long.valueOf(end) : ""));
    }

    @Override
    public Request boundary(String boundary) {
        this.requestMeta.boundary = boundary;
        return this;
    }

    @Override
    public Request acceptEncoding(boolean acceptEncoding) {
        if (!acceptEncoding) {
            this.requestMeta.headerMap.remove("Accept-Encoding");
        }
        return this;
    }

    @Override
    public Request addHeader(String name, String value) {
        if (!this.requestMeta.headerMap.containsKey(name)) {
            this.requestMeta.headerMap.put(name, new ArrayList());
        }
        this.requestMeta.headerMap.get(name).add(value);
        return this;
    }

    @Override
    public Request setHeader(String name, String value) {
        this.requestMeta.headerMap.put(name, new ArrayList<String>(Arrays.asList(value)));
        return this;
    }

    @Override
    public Request headers(Map<String, List<String>> headerMap) {
        this.requestMeta.headerMap.putAll(headerMap);
        return this;
    }

    @Override
    public Request cookie(String name, String value) {
        HttpCookie httpCookie = new HttpCookie(name, value);
        httpCookie.setMaxAge(3600000L);
        httpCookie.setPath("/");
        this.cookie(httpCookie);
        this.clientConfig.cookieOption.addCookie(httpCookie);
        return this;
    }

    @Override
    public Request cookie(String cookie) {
        this.clientConfig.cookieOption.addCookieString(this.requestMeta.url.getHost(), cookie);
        return this;
    }

    @Override
    public Request cookie(HttpCookie httpCookie) {
        if (null == httpCookie.getDomain() || httpCookie.getDomain().isEmpty()) {
            httpCookie.setDomain(this.requestMeta.url.getHost());
        }
        httpCookie.setVersion(0);
        httpCookie.setDiscard(false);
        this.clientConfig.cookieOption.addCookie(httpCookie);
        return this;
    }

    @Override
    public Request cookie(List<HttpCookie> httpCookieList) {
        for (HttpCookie httpCookie : httpCookieList) {
            this.cookie(httpCookie);
        }
        return null;
    }

    @Override
    public Request parameter(String key, String value) {
        this.requestMeta.parameterMap.put(key, value);
        return this;
    }

    @Override
    public Request data(String key, String value) {
        this.requestMeta.dataMap.put(key, value);
        return this;
    }

    @Override
    public Request data(String key, Path file) {
        this.requestMeta.dataFileMap.put(new String(key), file);
        return this;
    }

    @Override
    public Request data(Map<String, String> dataMap) {
        this.requestMeta.dataMap.putAll(dataMap);
        return this;
    }

    @Override
    public Request requestBody(String body) {
        this.requestMeta.requestBody = body.getBytes(Charset.forName(this.requestMeta.charset));
        return this;
    }

    @Override
    public Request requestBody(JSONObject body) {
        this.requestMeta.requestBody = body.toJSONString().getBytes(Charset.forName(this.requestMeta.charset));
        return this;
    }

    @Override
    public Request requestBody(JSONArray body) {
        this.requestMeta.requestBody = body.toJSONString().getBytes(Charset.forName(this.requestMeta.charset));
        return this;
    }

    @Override
    public Request requestBody(Path file) throws IOException {
        this.requestMeta.requestBody = Files.readAllBytes(file);
        this.requestMeta.contentType = Files.probeContentType(file);
        return this;
    }

    @Override
    public Request proxy(Proxy proxy) {
        this.requestMeta.proxy = proxy;
        return this;
    }

    @Override
    public Request proxy(String host, int port) {
        this.requestMeta.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        return this;
    }

    @Override
    public Request connectTimeout(int connectTimeoutMillis) {
        this.requestMeta.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    @Override
    public Request readTimeout(int readTimeoutMillis) {
        this.requestMeta.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    @Override
    public Request followRedirects(boolean followRedirects) {
        this.requestMeta.followRedirects = followRedirects;
        return this;
    }

    @Override
    public Request maxFollowRedirectTimes(int maxFollowRedirectTimes) {
        this.requestMeta.maxFollowRedirectTimes = maxFollowRedirectTimes;
        return this;
    }

    @Override
    public Request ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.requestMeta.ignoreHttpErrors = ignoreHttpErrors;
        return this;
    }

    @Override
    public Request retryTimes(int retryTimes) {
        this.requestMeta.retryTimes = retryTimes;
        return this;
    }

    @Override
    public Response execute() {
        RequestExecutor requestExecutor = new RequestExecutor(this, this.clientConfig);
        return requestExecutor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void enqueue(ResponseListener responseListener) {
        if (null == this.clientConfig.threadPoolExecutor) {
            Class<Request> clazz = Request.class;
            // MONITORENTER : cn.schoolwow.quickhttp.request.Request.class
            if (null == this.clientConfig.threadPoolExecutor) {
                this.clientConfig.threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
            }
            // MONITOREXIT : clazz
        }
        this.clientConfig.threadPoolExecutor.execute(() -> {
            Response response = this.execute();
            responseListener.executeSuccess(this, response);
        });
    }

    @Override
    public Request clone() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.requestMeta);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            RequestMeta requestMeta = (RequestMeta)ois.readObject();
            requestMeta.url = this.requestMeta.url;
            requestMeta.method = this.requestMeta.method;
            requestMeta.proxy = this.requestMeta.proxy;
            requestMeta.userContentType = this.requestMeta.userContentType;
            requestMeta.requestBody = this.requestMeta.requestBody;
            RequestImpl request = new RequestImpl(this.clientConfig);
            request.requestMeta = requestMeta;
            return request;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public RequestMeta requestMeta() {
        return this.requestMeta;
    }
}

