/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.query;

import cn.schoolwow.quickhttp.document.query.CombiningEvaluator;
import cn.schoolwow.quickhttp.document.query.Evaluator;
import cn.schoolwow.quickhttp.document.query.StructuralEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser {
    private static Logger logger = LoggerFactory.getLogger(QueryParser.class);
    private static final char[] combinators = new char[]{'>', '+', '~', ' '};
    private static final Map<String, Evaluator> pseudoMap = new HashMap<String, Evaluator>();
    private char[] chars;
    private int pos;
    private Evaluator root;
    private final Stack<Evaluator> evaluatorStack = new Stack();
    private CombiningEvaluator.Or or;

    public static Evaluator parse(String cssQuery) {
        return new QueryParser((String)cssQuery).root;
    }

    private QueryParser(String cssQuery) {
        this.evaluatorStack.clear();
        this.chars = cssQuery.toCharArray();
        Selector[] selectors = Selector.values();
        while (this.pos < this.chars.length) {
            boolean find = false;
            for (Selector selector : selectors) {
                int count = (Integer)selector.condition.apply(this);
                if (count <= 0) continue;
                this.pos += count;
                find = true;
                break;
            }
            if (find) continue;
            ++this.pos;
        }
        if (this.evaluatorStack.size() > 1) {
            CombiningEvaluator.And lastAnd = new CombiningEvaluator.And(new ArrayList<Evaluator>());
            while (!this.evaluatorStack.isEmpty() && !(this.evaluatorStack.peek() instanceof StructuralEvaluator)) {
                lastAnd.evaluatorList.add(this.evaluatorStack.pop());
            }
            this.evaluatorStack.push(lastAnd);
        }
        logger.trace("[\u539f\u59cb\u9009\u62e9\u5668\u5217\u8868]{}", this.evaluatorStack);
        if (this.or != null) {
            CombiningEvaluator.And and = new CombiningEvaluator.And(new ArrayList<Evaluator>());
            while (!this.evaluatorStack.isEmpty()) {
                and.evaluatorList.add(this.evaluatorStack.pop());
            }
            if (and.evaluatorList.size() == 1) {
                this.or.evaluatorList.add(and.evaluatorList.get(0));
            } else {
                this.or.evaluatorList.add(and);
            }
        }
        if (this.or != null) {
            this.root = this.or;
        } else if (this.evaluatorStack.size() == 1) {
            this.root = (Evaluator)this.evaluatorStack.get(0);
        } else {
            ArrayList<Evaluator> evaluatorList = new ArrayList<Evaluator>(this.evaluatorStack.size());
            while (!this.evaluatorStack.isEmpty()) {
                evaluatorList.add(this.evaluatorStack.pop());
            }
            this.root = new CombiningEvaluator.And(evaluatorList);
        }
        logger.trace("[\u6700\u7ec8\u9009\u62e9\u5668\u5217\u8868]{}", (Object)this.root);
    }

    private static boolean isCombinators(char c) {
        for (char combinator : combinators) {
            if (c != combinator) continue;
            return true;
        }
        return false;
    }

    static {
        pseudoMap.put(":first-child", new Evaluator.IsFirstChild());
        pseudoMap.put(":last-child", new Evaluator.IsLastChild());
        pseudoMap.put(":first-of-type", new Evaluator.IsFirstOfType());
        pseudoMap.put(":last-of-type", new Evaluator.IsLastOfType());
        pseudoMap.put(":only-child", new Evaluator.IsOnlyChild());
        pseudoMap.put(":only-of-type", new Evaluator.IsOnlyOfType());
        pseudoMap.put(":empty", new Evaluator.IsEmpty());
    }

    private static enum Selector {
        ByIdOrClass(queryParser -> {
            int last;
            int pos;
            char[] chars = ((QueryParser)queryParser).chars;
            if (chars[pos = ((QueryParser)queryParser).pos] != '#' && chars[pos] != '.') {
                return 0;
            }
            for (last = pos; last < chars.length - 1 && !QueryParser.isCombinators(chars[last]); ++last) {
            }
            int count = last - pos;
            if (last == chars.length - 1) {
                ++count;
            }
            String content = new String(chars, pos, count);
            if (chars[pos] == '#') {
                Evaluator.Id idEvaluator = new Evaluator.Id(content.substring(1));
                ((QueryParser)queryParser).evaluatorStack.push(idEvaluator);
                logger.trace("[\u6dfb\u52a0id\u9009\u62e9\u5668]{}", (Object)idEvaluator);
            } else if (chars[pos] == '.') {
                Evaluator.Class aClassEvaluator = new Evaluator.Class(content.substring(1));
                ((QueryParser)queryParser).evaluatorStack.push(aClassEvaluator);
                logger.trace("[\u6dfb\u52a0class\u9009\u62e9\u5668]{}", (Object)aClassEvaluator);
            }
            return content.length();
        }),
        ByTag(queryParser -> {
            int last;
            int pos;
            char[] chars = ((QueryParser)queryParser).chars;
            if (!Character.isLetterOrDigit(chars[pos = ((QueryParser)queryParser).pos])) {
                return 0;
            }
            for (last = pos; last < chars.length - 1 && Character.isLetterOrDigit(chars[last]); ++last) {
            }
            int count = last - pos;
            if (last == chars.length - 1) {
                ++count;
            }
            String content = new String(chars, pos, count);
            Evaluator.Tag tag = new Evaluator.Tag(content);
            ((QueryParser)queryParser).evaluatorStack.push(tag);
            logger.trace("[\u6dfb\u52a0tag\u9009\u62e9\u5668]{}", (Object)tag);
            return content.length();
        }),
        ByAll(queryParser -> {
            int pos;
            char[] chars = ((QueryParser)queryParser).chars;
            if (chars[pos = ((QueryParser)queryParser).pos] != '*') {
                return 0;
            }
            ((QueryParser)queryParser).evaluatorStack.push(new Evaluator.AllElements());
            return 1;
        }),
        ByAttribute(queryParser -> {
            int last;
            int pos;
            char[] chars = ((QueryParser)queryParser).chars;
            if (chars[pos = ((QueryParser)queryParser).pos] != '[') {
                return 0;
            }
            for (last = pos; last < chars.length - 1 && chars[last] != ']'; ++last) {
            }
            int count = last - pos + 1;
            String content = new String(chars, pos, count);
            String escapeContent = content.substring(1, content.length() - 1).replaceAll("[\"|']]", "");
            Evaluator evaluator = null;
            if (content.charAt(1) == '^') {
                evaluator = new Evaluator.AttributeStarting(content.substring(2, content.length() - 1));
            } else if (content.contains("^=")) {
                String key = escapeContent.substring(0, escapeContent.indexOf("^="));
                String value = escapeContent.substring(escapeContent.indexOf("^=") + 2);
                evaluator = new Evaluator.AttributeWithValueStarting(key, value);
            } else if (content.contains("$=")) {
                String key = escapeContent.substring(0, escapeContent.indexOf("$="));
                String value = escapeContent.substring(escapeContent.indexOf("$=") + 2);
                evaluator = new Evaluator.AttributeWithValueEnding(key, value);
            } else if (content.contains("*=")) {
                String key = escapeContent.substring(0, escapeContent.indexOf("*="));
                String value = escapeContent.substring(escapeContent.indexOf("*=") + 2);
                evaluator = new Evaluator.AttributeWithValueContaining(key, value);
            } else if (content.contains("~=")) {
                String key = escapeContent.substring(0, escapeContent.indexOf("~="));
                String pattern = escapeContent.substring(escapeContent.indexOf("~=") + 2);
                evaluator = new Evaluator.AttributeWithValueMatching(key, Pattern.compile(pattern));
            } else if (content.contains("=")) {
                String key = escapeContent.substring(0, escapeContent.indexOf("="));
                String value = escapeContent.substring(escapeContent.indexOf("=") + 1);
                evaluator = new Evaluator.AttributeWithValue(key, value);
            } else {
                evaluator = new Evaluator.Attribute(content.substring(1, content.length() - 1));
            }
            ((QueryParser)queryParser).evaluatorStack.push(evaluator);
            logger.trace("[\u6dfb\u52a0{}\u9009\u62e9\u5668]{}", (Object)evaluator.getClass().getSimpleName(), (Object)evaluator);
            return content.length();
        }),
        ByOr(queryParser -> {
            int last;
            int pos;
            char[] chars = ((QueryParser)queryParser).chars;
            if (chars[pos = ((QueryParser)queryParser).pos] != ' ' && chars[pos] != ',') {
                return 0;
            }
            for (last = pos; last < chars.length - 1 && (chars[last] == ' ' || chars[last] == ','); ++last) {
            }
            String content = new String(chars, pos, last - pos);
            if (!content.contains(",")) {
                return 0;
            }
            CombiningEvaluator.And and = new CombiningEvaluator.And(new ArrayList<Evaluator>());
            while (!((QueryParser)queryParser).evaluatorStack.isEmpty() && !(((QueryParser)queryParser).evaluatorStack.peek() instanceof CombiningEvaluator.And)) {
                and.evaluatorList.add(((QueryParser)queryParser).evaluatorStack.pop());
            }
            if (((QueryParser)queryParser).or == null) {
                ((QueryParser)queryParser).or = new CombiningEvaluator.Or(new ArrayList<Evaluator>());
                logger.trace("[\u6dfb\u52a0Or\u9009\u62e9\u5668]{}", (Object)((QueryParser)queryParser).or);
            }
            if (and.evaluatorList.size() == 1) {
                ((QueryParser)queryParser).or.evaluatorList.add(and.evaluatorList.get(0));
            } else {
                ((QueryParser)queryParser).or.evaluatorList.add(and);
            }
            logger.trace("[Or\u9009\u62e9\u5668\u4e2d\u6dfb\u52a0And\u9009\u62e9\u5668]{}", (Object)and);
            return content.length();
        }),
        ByCombination(queryParser -> {
            int last;
            int pos;
            char[] chars = ((QueryParser)queryParser).chars;
            if (!QueryParser.isCombinators(chars[pos = ((QueryParser)queryParser).pos])) {
                return 0;
            }
            for (last = pos; last < chars.length - 1 && QueryParser.isCombinators(chars[last]); ++last) {
            }
            String content = new String(chars, pos, last - pos);
            ArrayList<Evaluator> evaluatorList = new ArrayList<Evaluator>();
            while (!((QueryParser)queryParser).evaluatorStack.isEmpty() && !(((QueryParser)queryParser).evaluatorStack.peek() instanceof StructuralEvaluator)) {
                evaluatorList.add((Evaluator)((QueryParser)queryParser).evaluatorStack.pop());
            }
            Evaluator lastEvaluator = null;
            lastEvaluator = evaluatorList.size() == 1 ? (Evaluator)evaluatorList.get(0) : new CombiningEvaluator.And(evaluatorList);
            if (!((QueryParser)queryParser).evaluatorStack.isEmpty()) {
                CombiningEvaluator.And and = new CombiningEvaluator.And(new ArrayList<Evaluator>());
                and.evaluatorList.add(lastEvaluator);
                and.evaluatorList.add(((QueryParser)queryParser).evaluatorStack.pop());
                lastEvaluator = and;
            }
            StructuralEvaluator evaluator = null;
            if (content.contains(">")) {
                evaluator = new StructuralEvaluator.ImmediateParent(lastEvaluator);
            } else if (content.contains("+")) {
                evaluator = new StructuralEvaluator.ImmediatePreviousSibling(lastEvaluator);
            } else if (content.contains("~")) {
                evaluator = new StructuralEvaluator.PreviousSibling(lastEvaluator);
            } else if (content.contains(" ")) {
                evaluator = new StructuralEvaluator.Parent(lastEvaluator);
            }
            ((QueryParser)queryParser).evaluatorStack.push(evaluator);
            logger.trace("[\u6dfb\u52a0Combination\u9009\u62e9\u5668]{}", (Object)evaluator);
            return content.length();
        }),
        ByPseudoCommon(queryParser -> {
            int count;
            char[] chars = ((QueryParser)queryParser).chars;
            int pos = ((QueryParser)queryParser).pos;
            if (pos + (count = ":first-of-type".length()) >= chars.length) {
                count = chars.length - pos;
            }
            String prefix = new String(chars, pos, count);
            Set keySet = pseudoMap.keySet();
            String targetKey = null;
            for (String key : keySet) {
                if (!prefix.startsWith(key)) continue;
                targetKey = key;
                break;
            }
            if (targetKey == null) {
                return 0;
            }
            ((QueryParser)queryParser).evaluatorStack.push(pseudoMap.get(targetKey));
            return targetKey.length();
        }),
        ByNth(queryParser -> {
            int last;
            char[] chars = ((QueryParser)queryParser).chars;
            int pos = ((QueryParser)queryParser).pos;
            if (pos + 5 >= chars.length) {
                return 0;
            }
            String prefix = new String(chars, pos, 5);
            if (!prefix.equals(":nth-")) {
                return 0;
            }
            for (last = pos; last < chars.length - 1 && chars[last] != ')'; ++last) {
            }
            int count = last - pos + 1;
            String content = new String(chars, pos, count);
            String data = content.substring(content.indexOf("(") + 1, content.lastIndexOf(")"));
            int a = -1;
            int b = -1;
            if (data.contains("n")) {
                String token1 = data.substring(0, data.indexOf("n"));
                String token2 = data.substring(data.indexOf("n") + 1);
                if (!token1.equals("-")) {
                    a = Integer.parseInt(token1);
                }
                b = Integer.parseInt(token2);
            } else {
                a = 0;
                b = Integer.parseInt(data);
            }
            if (a < 0 && b < 0) {
                return 0;
            }
            Evaluator.CssNthEvaluator structuralEvaluator = null;
            if (content.startsWith(":nth-child(")) {
                structuralEvaluator = new Evaluator.IsNthChild(a, b);
            } else if (content.startsWith(":nth-last-child(")) {
                structuralEvaluator = new Evaluator.IsNthLastChild(a, b);
            } else if (content.startsWith(":nth-of-type(")) {
                structuralEvaluator = new Evaluator.IsNthOfType(a, b);
            } else if (content.startsWith(":nth-last-of-type(")) {
                structuralEvaluator = new Evaluator.IsNthLastOfType(a, b);
            }
            ((QueryParser)queryParser).evaluatorStack.push(structuralEvaluator);
            logger.trace("[\u6dfb\u52a0Nth\u9009\u62e9\u5668]{}", (Object)structuralEvaluator);
            return content.length();
        }),
        ByPseudo(queryParser -> {
            int last;
            int pos;
            char[] chars = ((QueryParser)queryParser).chars;
            if (chars[pos = ((QueryParser)queryParser).pos] != ':') {
                return 0;
            }
            for (last = pos; last < chars.length - 1 && chars[last] != ')'; ++last) {
            }
            String content = new String(chars, pos, last - pos + 1);
            String data = content.substring(content.indexOf("(") + 1, content.lastIndexOf(")"));
            Evaluator evaluator = null;
            if (content.contains(":lt")) {
                evaluator = new Evaluator.IndexLessThan(Integer.parseInt(data));
            } else if (content.contains(":gt")) {
                evaluator = new Evaluator.IndexGreaterThan(Integer.parseInt(data));
            } else if (content.contains(":eq")) {
                evaluator = new Evaluator.IndexEquals(Integer.parseInt(data));
            } else if (content.contains(":has")) {
                evaluator = new StructuralEvaluator.Has((Evaluator)((QueryParser)queryParser).evaluatorStack.pop());
            } else if (content.contains(":not")) {
                evaluator = new StructuralEvaluator.Not((Evaluator)((QueryParser)queryParser).evaluatorStack.pop());
            } else if (content.contains(":containsOwn")) {
                evaluator = new Evaluator.ContainsOwnText(data);
            } else if (content.contains(":matchesOwn")) {
                evaluator = new Evaluator.MatchesOwn(Pattern.compile(data));
            } else if (content.contains(":contains")) {
                evaluator = new Evaluator.ContainsText(data);
            } else if (content.contains(":matches")) {
                evaluator = new Evaluator.Matches(Pattern.compile(data));
            }
            ((QueryParser)queryParser).evaluatorStack.push(evaluator);
            logger.trace("[\u6dfb\u52a0\u4f2a\u7c7b\u9009\u62e9\u5668]{}", (Object)evaluator);
            return content.length();
        });

        private Function<QueryParser, Integer> condition;

        private Selector(Function<QueryParser, Integer> condition) {
            this.condition = condition;
        }
    }
}

