/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.element;

import cn.schoolwow.quickhttp.document.element.Element;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Elements
extends ArrayList<Element> {
    public Elements() {
    }

    public Elements(int initialCapacity) {
        super(initialCapacity);
    }

    public Elements(Collection<Element> elements) {
        super(elements);
    }

    public Elements(List<Element> elements) {
        super(elements);
    }

    public Elements(Element ... elements) {
        super(Arrays.asList(elements));
    }

    public Element first() {
        if (this.isEmpty()) {
            return null;
        }
        return (Element)this.get(0);
    }

    public Element last() {
        if (this.isEmpty()) {
            return null;
        }
        return (Element)this.get(this.size() - 1);
    }

    public String tagName() {
        return ((Element)this.get(0)).tagName();
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Element element : this) {
            sb.append(element.text() + " ");
        }
        return sb.toString();
    }

    public boolean hasAttr(String attributeKey) {
        for (Element element : this) {
            if (!element.hasAttr(attributeKey)) continue;
            return true;
        }
        return false;
    }

    public String attr(String attributeKey) {
        for (Element element : this) {
            if (!element.hasAttr(attributeKey)) continue;
            return element.attr(attributeKey);
        }
        return null;
    }

    public List<String> eachAttr(String attributeKey) {
        ArrayList<String> attrs = new ArrayList<String>(this.size());
        for (Element element : this) {
            if (!element.hasAttr(attributeKey)) continue;
            attrs.add(element.attr(attributeKey));
        }
        return attrs;
    }

    public List<String> eachText() {
        ArrayList<String> texts = new ArrayList<String>(this.size());
        for (Element element : this) {
            texts.add(element.text());
        }
        return texts;
    }

    public Elements remove() {
        Elements elements = new Elements(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Element e = (Element)this.get(i);
            e.remove();
            elements.add(e);
        }
        return elements;
    }
}

