/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.client;

import cn.schoolwow.quickhttp.client.CookieOption;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CookieOptionImpl
implements CookieOption {
    private CookieManager cookieManager;

    public CookieOptionImpl(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    @Override
    public boolean hasDomainCookie(String domain) {
        List<HttpCookie> httpCookieListStore = this.cookieManager.getCookieStore().getCookies();
        for (HttpCookie httpCookie : httpCookieListStore) {
            if (!httpCookie.getDomain().contains(domain)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCookie(String domain, String name) {
        List<HttpCookie> httpCookieListStore = this.cookieManager.getCookieStore().getCookies();
        for (HttpCookie httpCookie : httpCookieListStore) {
            if (!httpCookie.getDomain().contains(domain) || !httpCookie.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCookie(String domain, String name, String value) {
        List<HttpCookie> httpCookieListStore = this.cookieManager.getCookieStore().getCookies();
        for (HttpCookie httpCookie : httpCookieListStore) {
            if (!httpCookie.getDomain().contains(domain) || !httpCookie.getName().equals(name) || !httpCookie.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCookieString(String domain) {
        List<HttpCookie> httpCookieList = this.getCookieList(domain);
        StringBuilder builder = new StringBuilder();
        for (HttpCookie httpCookie : httpCookieList) {
            builder.append(httpCookie.getName() + "=" + httpCookie.getValue() + ";");
        }
        return builder.toString();
    }

    @Override
    public HttpCookie getCookie(String domain, String name) {
        List<HttpCookie> httpCookieListStore = this.cookieManager.getCookieStore().getCookies();
        for (HttpCookie httpCookie : httpCookieListStore) {
            if (!httpCookie.getDomain().contains(domain) || !httpCookie.getName().equals(name)) continue;
            return httpCookie;
        }
        return null;
    }

    @Override
    public List<HttpCookie> getCookieList(String domain) {
        ArrayList<HttpCookie> httpCookieList = new ArrayList<HttpCookie>();
        List<HttpCookie> httpCookieListStore = this.cookieManager.getCookieStore().getCookies();
        for (HttpCookie httpCookie : httpCookieListStore) {
            if (!httpCookie.getDomain().contains(domain)) continue;
            httpCookieList.add(httpCookie);
        }
        return httpCookieList;
    }

    @Override
    public List<HttpCookie> getCookieList() {
        return this.cookieManager.getCookieStore().getCookies();
    }

    @Override
    public void addCookieString(String domain, String cookie) {
        this.addCookieString(domain, "/", cookie);
    }

    @Override
    public void addCookieString(String domain, String path, String cookie) {
        if (null == cookie || cookie.isEmpty()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(cookie, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int startIndex = token.indexOf("=");
            String name = token.substring(0, startIndex).trim();
            String value = token.substring(startIndex + 1).trim();
            this.addCookie(domain, path, name, value);
        }
    }

    @Override
    public void addCookie(String domain, String name, String value) {
        this.addCookie(domain, "/", name, value);
    }

    @Override
    public void addCookie(String domain, String path, String name, String value) {
        HttpCookie httpCookie = new HttpCookie(name, value);
        httpCookie.setMaxAge(3600000L);
        httpCookie.setDomain(domain);
        httpCookie.setPath(path);
        httpCookie.setVersion(0);
        httpCookie.setDiscard(false);
        this.addCookie(httpCookie);
    }

    @Override
    public void addCookie(HttpCookie httpCookie) {
        String domain = httpCookie.getDomain();
        if (null == domain || domain.isEmpty()) {
            throw new IllegalArgumentException("cookie\u7684domain\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (domain.startsWith(".")) {
            httpCookie.setDomain("." + domain);
        }
        if (null == httpCookie.getPath() || httpCookie.getPath().isEmpty()) {
            httpCookie.setPath("/");
        }
        if (httpCookie.getMaxAge() <= 0L) {
            httpCookie.setMaxAge(3600L);
        }
        this.cookieManager.getCookieStore().add(null, httpCookie);
    }

    @Override
    public void addCookie(List<HttpCookie> httpCookieList) {
        for (HttpCookie httpCookie : httpCookieList) {
            this.addCookie(httpCookie);
        }
    }

    @Override
    public void removeCookie(String domain) {
        List<HttpCookie> httpCookieList = this.getCookieList(domain);
        for (HttpCookie httpCookie : httpCookieList) {
            this.cookieManager.getCookieStore().remove(null, httpCookie);
        }
    }

    @Override
    public void removeCookie(String domain, String name) {
        HttpCookie httpCookie = this.getCookie(domain, name);
        this.cookieManager.getCookieStore().remove(null, httpCookie);
    }

    @Override
    public void removeCookie(HttpCookie httpCookie) {
        this.cookieManager.getCookieStore().remove(null, httpCookie);
    }

    @Override
    public boolean clearCookieList() {
        return this.cookieManager.getCookieStore().removeAll();
    }

    @Override
    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        this.cookieManager.setCookiePolicy(cookiePolicy);
    }

    @Override
    public CookieManager cookieManager() {
        return this.cookieManager;
    }
}

