/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.request;

import cn.schoolwow.quickhttp.document.Document;
import cn.schoolwow.quickhttp.document.element.Element;
import cn.schoolwow.quickhttp.document.element.Elements;
import cn.schoolwow.quickhttp.domain.ClientConfig;
import cn.schoolwow.quickhttp.domain.QuickHttpConfig;
import cn.schoolwow.quickhttp.domain.RequestMeta;
import cn.schoolwow.quickhttp.domain.ResponseMeta;
import cn.schoolwow.quickhttp.listener.QuickHttpClientListener;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import cn.schoolwow.quickhttp.response.ResponseImpl;
import cn.schoolwow.quickhttp.response.SpeedLimitInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestExecutor {
    private Logger logger = LoggerFactory.getLogger(RequestExecutor.class);
    private static ThreadLocal<StringBuilder> builderThreadLocal = new ThreadLocal();
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int boundaryLength = 32;
    private Request request;
    private RequestMeta requestMeta;
    private ClientConfig clientConfig;
    private Response response;
    private ResponseMeta responseMeta;

    public RequestExecutor(Request request, ClientConfig clientConfig) {
        this.request = request;
        this.requestMeta = request.requestMeta();
        this.clientConfig = clientConfig;
    }

    public Response execute() {
        this.checkRequestMeta();
        List<QuickHttpClientListener> quickHttpClientListenerList = this.clientConfig.quickHttpClientListenerList;
        for (QuickHttpClientListener quickHttpClientListener : quickHttpClientListenerList) {
            quickHttpClientListener.beforeExecute(this.request);
        }
        try {
            for (int retryTimes = 1; retryTimes <= this.clientConfig.retryTimes; ++retryTimes) {
                try {
                    HttpURLConnection httpURLConnection = this.createHttpUrlConnection();
                    this.response = this.getResponse(httpURLConnection);
                    break;
                }
                catch (ConnectException | SocketTimeoutException e) {
                    this.logger.warn("[\u94fe\u63a5\u8d85\u65f6]\u91cd\u8bd5{}/{},\u539f\u56e0:{},\u5730\u5740:{}", new Object[]{retryTimes, this.clientConfig.retryTimes, e.getMessage(), this.requestMeta.url});
                    this.requestMeta.connectTimeoutMillis *= 2;
                    this.requestMeta.readTimeoutMillis *= 2;
                    continue;
                }
            }
            this.handleRedirect(this.request, this.response);
            for (QuickHttpClientListener quickHttpClientListener : quickHttpClientListenerList) {
                quickHttpClientListener.executeSuccess(this.request, this.response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            for (QuickHttpClientListener quickHttpClientListener : quickHttpClientListenerList) {
                quickHttpClientListener.executeFail(this.request, e);
            }
        }
        return this.response;
    }

    private Response handleRedirect(Request request, Response response) throws IOException {
        int followRedirectTimes = 0;
        String location = this.responseMeta.httpURLConnection.getHeaderField("Location");
        while (this.requestMeta.followRedirects && null != location) {
            if (followRedirectTimes >= this.requestMeta.maxFollowRedirectTimes) {
                throw new IOException("\u91cd\u5b9a\u5411\u6b21\u6570\u8fc7\u591a!\u9650\u5236\u6700\u5927\u6b21\u6570:" + this.requestMeta.maxFollowRedirectTimes);
            }
            if (location.startsWith("http")) {
                request.url(location);
            } else if (location.startsWith("/")) {
                request.url(this.requestMeta.url.getProtocol() + "://" + this.requestMeta.url.getHost() + ":" + (this.requestMeta.url.getPort() == -1 ? this.requestMeta.url.getDefaultPort() : this.requestMeta.url.getPort()) + location);
            } else {
                String u = this.requestMeta.url.toString();
                request.url(u.substring(0, u.lastIndexOf("/")) + "/" + location);
            }
            request.method(Request.Method.GET);
            this.requestMeta.dataFileMap.clear();
            this.requestMeta.dataMap.clear();
            this.requestMeta.requestBody = null;
            ++followRedirectTimes;
            response = this.execute();
            location = this.responseMeta.httpURLConnection.getHeaderField("Location");
        }
        return response;
    }

    private Response getResponse(HttpURLConnection httpURLConnection) throws IOException {
        this.responseMeta = new ResponseMeta();
        this.responseMeta.httpURLConnection = httpURLConnection;
        try {
            this.responseMeta.statusCode = httpURLConnection.getResponseCode();
            this.responseMeta.statusMessage = httpURLConnection.getResponseMessage();
        }
        catch (FileNotFoundException e) {
            this.responseMeta.statusCode = 404;
            this.responseMeta.statusMessage = "Not Found";
        }
        if (null == this.responseMeta.statusMessage) {
            this.responseMeta.statusMessage = "";
        }
        if (!(this.requestMeta.ignoreHttpErrors || this.responseMeta.statusCode >= 200 && this.responseMeta.statusCode < 400)) {
            throw new IOException("http\u72b6\u6001\u5f02\u5e38!\u72b6\u6001\u7801:" + this.responseMeta.statusCode + ",\u5730\u5740:" + this.requestMeta.url);
        }
        this.responseMeta.topHost = this.responseMeta.httpURLConnection.getURL().getHost();
        String substring = this.responseMeta.topHost.substring(0, this.responseMeta.topHost.lastIndexOf("."));
        if (substring.contains(".")) {
            this.responseMeta.topHost = this.responseMeta.topHost.substring(substring.lastIndexOf(".") + 1);
        }
        Map<String, List<String>> headerFields = httpURLConnection.getHeaderFields();
        Set<String> keySet = headerFields.keySet();
        for (String key : keySet) {
            if (null == key) continue;
            String value = httpURLConnection.getHeaderField(key);
            value = new String(value.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            this.responseMeta.headerMap.put(key, value);
        }
        try {
            InputStream inputStream;
            String contentEncoding = httpURLConnection.getContentEncoding();
            InputStream inputStream2 = inputStream = httpURLConnection.getErrorStream() != null ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
            if (contentEncoding != null && !contentEncoding.isEmpty()) {
                if (contentEncoding.equals("gzip")) {
                    inputStream = new GZIPInputStream(inputStream);
                } else if (contentEncoding.equals("deflate")) {
                    inputStream = new InflaterInputStream(inputStream, new Inflater(true));
                }
            }
            this.responseMeta.inputStream = inputStream;
            this.responseMeta.inputStream = new BufferedInputStream(inputStream);
            this.responseMeta.inputStream = new SpeedLimitInputStream(this.responseMeta.inputStream);
        }
        catch (FileNotFoundException e) {
            this.logger.warn("[\u8bfb\u53d6\u8f93\u5165\u6d41\u5931\u8d25]");
        }
        this.getCharset();
        try {
            this.clientConfig.cookieManager.put(httpURLConnection.getURL().toURI(), httpURLConnection.getHeaderFields());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ResponseImpl response = new ResponseImpl(this.requestMeta, this.responseMeta, this.clientConfig);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[\u8bf7\u6c42\u4e0e\u54cd\u5e94]\n{}", (Object)this.getRequestAndResponseLog(this.requestMeta, response));
        }
        return response;
    }

    private void getCharset() throws IOException {
        this.getCharsetFromContentType(this.responseMeta.httpURLConnection.getContentType());
        if (this.responseMeta.charset == null) {
            byte[] bytes = new byte[5120];
            this.responseMeta.inputStream.mark(bytes.length);
            this.responseMeta.inputStream.read(bytes, 0, bytes.length);
            boolean readFully = this.responseMeta.inputStream.read() == -1;
            this.responseMeta.inputStream.reset();
            ByteBuffer firstBytes = ByteBuffer.wrap(bytes);
            this.getCharsetFromBOM(firstBytes);
            if (this.responseMeta.charset == null) {
                this.getCharsetFromMeta(firstBytes, readFully);
            }
        }
        if (this.responseMeta.charset == null) {
            this.responseMeta.charset = "utf-8";
        }
    }

    private void getCharsetFromMeta(ByteBuffer byteBuffer, boolean readFully) {
        String docData = StandardCharsets.UTF_8.decode(byteBuffer).toString();
        if (!docData.startsWith("<?xml") && !docData.startsWith("<!DOCTYPE")) {
            return;
        }
        Document doc = Document.parse(docData);
        if (doc.root() == null) {
            return;
        }
        Elements metaElements = doc.select("meta[http-equiv=content-type], meta[charset]");
        Iterator iterator = metaElements.iterator();
        if (iterator.hasNext()) {
            Element meta = (Element)iterator.next();
            if (meta.hasAttr("http-equiv")) {
                this.getCharsetFromContentType(meta.attr("content"));
            }
            if (this.responseMeta.charset == null && meta.hasAttr("charset")) {
                this.responseMeta.charset = meta.attr("charset");
            }
        }
        if (this.responseMeta.charset == null) {
            Element root = doc.root();
            if (doc.root().tagName().equals("?xml") && root.hasAttr("encoding")) {
                this.responseMeta.charset = root.attr("encoding");
            }
        }
        if (readFully) {
            this.responseMeta.document = doc;
        }
    }

    private void getCharsetFromBOM(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer buffer = byteBuffer;
        ((Buffer)buffer).mark();
        byte[] bom = new byte[4];
        if (byteBuffer.remaining() >= bom.length) {
            byteBuffer.get(bom);
            ((Buffer)buffer).rewind();
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 || bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.responseMeta.charset = "utf-32";
        } else if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
            this.responseMeta.charset = "utf-16";
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.responseMeta.charset = "utf-8";
        }
        if (this.responseMeta.charset != null) {
            this.responseMeta.inputStream.skip(1L);
        }
    }

    private void getCharsetFromContentType(String contentType) {
        int startIndex;
        String prefix = "charset=";
        if (contentType != null && contentType.contains(prefix) && (startIndex = contentType.indexOf(prefix)) >= 0) {
            int endIndex = contentType.lastIndexOf(";");
            if (endIndex > startIndex) {
                this.responseMeta.charset = contentType.substring(startIndex + prefix.length(), endIndex).trim();
            } else if (endIndex < startIndex) {
                this.responseMeta.charset = contentType.substring(startIndex + prefix.length()).trim();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection createHttpUrlConnection() throws IOException {
        if (!this.requestMeta.parameters.isEmpty()) {
            StringBuilder parameterBuilder = RequestExecutor.getBuilder();
            Set<Map.Entry<String, String>> entrySet = this.requestMeta.parameters.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                void var5_6;
                String string = entry.getValue();
                if (null != string) {
                    String string2 = URLEncoder.encode(string, this.requestMeta.charset);
                }
                parameterBuilder.append(URLEncoder.encode(entry.getKey(), this.requestMeta.charset) + "=" + (String)var5_6 + "&");
            }
            parameterBuilder.deleteCharAt(parameterBuilder.length() - 1);
            if (this.requestMeta.url.toString().contains("?")) {
                parameterBuilder.insert(0, "&");
            } else {
                parameterBuilder.insert(0, "?");
            }
            this.requestMeta.url = new URL(this.requestMeta.url.toString() + parameterBuilder.toString());
        }
        URL u = this.requestMeta.url;
        HttpURLConnection httpURLConnection = (HttpURLConnection)(this.requestMeta.proxy == null ? u.openConnection() : u.openConnection(this.requestMeta.proxy));
        this.logger.info("[\u8bf7\u6c42\u884c]{} {},\u4ee3\u7406:{}", new Object[]{this.requestMeta.method.name(), u, this.requestMeta.proxy == null ? "\u65e0" : this.requestMeta.proxy.address()});
        if (httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.clientConfig.sslSocketFactory);
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.clientConfig.hostnameVerifier);
        }
        httpURLConnection.setRequestMethod(this.requestMeta.method.name());
        httpURLConnection.setConnectTimeout(this.requestMeta.connectTimeoutMillis);
        httpURLConnection.setReadTimeout(this.requestMeta.readTimeoutMillis);
        httpURLConnection.setInstanceFollowRedirects(false);
        Set<Map.Entry<String, String>> entrySet = this.requestMeta.headers.entrySet();
        for (Map.Entry entry : entrySet) {
            httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        httpURLConnection.setDoInput(true);
        if (!(!this.requestMeta.method.hasBody() || this.requestMeta.dataFileMap.isEmpty() && null == this.requestMeta.requestBody && this.requestMeta.dataMap.isEmpty())) {
            if (Request.ContentType.MULTIPART_FORMDATA.equals((Object)this.requestMeta.userContentType) || !this.requestMeta.dataFileMap.isEmpty()) {
                if (null == this.requestMeta.boundary) {
                    this.requestMeta.boundary = RequestExecutor.mimeBoundary();
                }
                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.requestMeta.boundary);
                httpURLConnection.setChunkedStreamingMode(0);
                MDC.put((String)"body", (String)this.requestMeta.dataFileMap.toString());
            } else if (Request.ContentType.APPLICATION_JSON.equals((Object)this.requestMeta.userContentType) || this.requestMeta.requestBody != null && this.requestMeta.requestBody.length > 0) {
                httpURLConnection.setRequestProperty("Content-Type", (Object)((Object)this.requestMeta.userContentType) + "; charset=" + this.requestMeta.charset + ";");
                httpURLConnection.setFixedLengthStreamingMode(this.requestMeta.requestBody.length);
                MDC.put((String)"body", (String)(this.requestMeta.userContentType.equals("application/json") ? new String(this.requestMeta.requestBody) : ""));
            } else if (Request.ContentType.APPLICATION_X_WWW_FORM_URLENCODED.equals((Object)this.requestMeta.userContentType) || !this.requestMeta.dataMap.isEmpty()) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + this.requestMeta.charset);
                if (!this.requestMeta.dataMap.isEmpty()) {
                    StringBuilder formBuilder = RequestExecutor.getBuilder();
                    Set<Map.Entry<String, String>> entrySet2 = this.requestMeta.dataMap.entrySet();
                    for (Map.Entry<String, String> entry : entrySet2) {
                        String value = entry.getValue();
                        if (null != value) {
                            value = URLEncoder.encode(value, this.requestMeta.charset);
                        }
                        formBuilder.append(URLEncoder.encode(entry.getKey(), this.requestMeta.charset) + "=" + value + "&");
                    }
                    formBuilder.deleteCharAt(formBuilder.length() - 1);
                    this.requestMeta.requestBody = formBuilder.toString().getBytes();
                }
                httpURLConnection.setFixedLengthStreamingMode(this.requestMeta.requestBody.length);
                MDC.put((String)"body", (String)this.requestMeta.dataMap.toString());
            }
            if (null != this.requestMeta.contentType && this.requestMeta.contentType.isEmpty()) {
                httpURLConnection.setRequestProperty("Content-Type", this.requestMeta.contentType);
            }
            httpURLConnection.setDoOutput(true);
            try {
                this.clientConfig.cookieManager.get(this.requestMeta.url.toURI(), httpURLConnection.getHeaderFields());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            OutputStream outputStream = httpURLConnection.getOutputStream();
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(outputStream, this.requestMeta.charset));
            if (Request.ContentType.MULTIPART_FORMDATA.equals((Object)this.requestMeta.userContentType) || !this.requestMeta.dataFileMap.isEmpty()) {
                if (!this.requestMeta.dataMap.isEmpty()) {
                    Set<Map.Entry<String, String>> set = this.requestMeta.dataMap.entrySet();
                    for (Map.Entry<String, Object> entry : set) {
                        w.write("--" + this.requestMeta.boundary + "\r\n");
                        w.write("Content-Disposition: form-data; name=\"" + entry.getKey().replace("\"", "%22") + "\"\r\n");
                        w.write("\r\n");
                        w.write((String)entry.getValue());
                        w.write("\r\n");
                    }
                }
                Set<Map.Entry<String, Path>> set = this.requestMeta.dataFileMap.entrySet();
                for (Map.Entry<String, Object> entry : set) {
                    Path file = (Path)entry.getValue();
                    String name = entry.getKey().replace("\"", "%22");
                    w.write("--" + this.requestMeta.boundary + "\r\n");
                    w.write("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.getFileName().toString().replace("\"", "%22") + "\"\r\n");
                    w.write("Content-Type: " + Files.probeContentType(file) + "\r\n");
                    w.write("\r\n");
                    w.flush();
                    outputStream.write(Files.readAllBytes(file));
                    outputStream.flush();
                    w.write("\r\n");
                }
                w.write("--" + this.requestMeta.boundary + "--\r\n");
            } else if (Request.ContentType.APPLICATION_JSON.equals((Object)this.requestMeta.userContentType) || this.requestMeta.requestBody != null && !this.requestMeta.requestBody.equals("")) {
                outputStream.write(this.requestMeta.requestBody);
            } else if ((Request.ContentType.APPLICATION_X_WWW_FORM_URLENCODED.equals((Object)this.requestMeta.userContentType) || !this.requestMeta.dataMap.isEmpty()) && null != this.requestMeta.requestBody) {
                outputStream.write(this.requestMeta.requestBody);
            }
            w.flush();
            w.close();
        }
        return httpURLConnection;
    }

    private void checkRequestMeta() {
        if (null == this.requestMeta.url) {
            throw new IllegalArgumentException("url\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String protocol = this.requestMeta.url.getProtocol();
        if (!protocol.startsWith("http")) {
            throw new IllegalArgumentException("\u5f53\u524d\u53ea\u652f\u6301http\u548chttps\u534f\u8bae.\u5f53\u524durl:" + this.requestMeta.url);
        }
        if (null == this.requestMeta.proxy) {
            this.requestMeta.proxy = this.clientConfig.proxy;
        }
        if (null == this.requestMeta.proxy) {
            this.requestMeta.proxy = QuickHttpConfig.proxy;
        }
        if (3000 == this.requestMeta.connectTimeoutMillis) {
            this.requestMeta.connectTimeoutMillis = this.clientConfig.connectTimeoutMillis;
        }
        if (5000 == this.requestMeta.readTimeoutMillis) {
            this.requestMeta.readTimeoutMillis = this.clientConfig.readTimeoutMillis;
        }
        if (this.requestMeta.followRedirects) {
            this.requestMeta.followRedirects = this.clientConfig.followRedirects;
        }
        if (20 == this.requestMeta.maxFollowRedirectTimes) {
            this.requestMeta.maxFollowRedirectTimes = this.clientConfig.maxFollowRedirectTimes;
        }
        if (!this.requestMeta.ignoreHttpErrors) {
            this.requestMeta.ignoreHttpErrors = this.clientConfig.ignoreHttpErrors;
        }
        if (3 == this.requestMeta.retryTimes) {
            this.requestMeta.retryTimes = this.clientConfig.retryTimes;
        }
    }

    private String getRequestAndResponseLog(RequestMeta requestMeta, Response response) throws IOException {
        String cookie;
        ResponseMeta responseMeta = response.responseMeta();
        HttpURLConnection httpURLConnection = responseMeta.httpURLConnection;
        StringBuilder contentBuilder = new StringBuilder((Object)((Object)requestMeta.method) + " " + requestMeta.url + " HTTP/1.1\n");
        Set<Map.Entry<String, String>> requestHeaderSet = requestMeta.headers.entrySet();
        for (Map.Entry<String, String> entry : requestHeaderSet) {
            contentBuilder.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        if (null != requestMeta.contentType && requestMeta.contentType.isEmpty()) {
            contentBuilder.append("Content-Type: " + requestMeta.contentType + "\n");
        }
        if (null != (cookie = responseMeta.httpURLConnection.getRequestProperty("Cookie"))) {
            contentBuilder.append("Cookie: " + cookie + "\n");
        }
        contentBuilder.append("\n" + MDC.get((String)"body") + "\n\n");
        contentBuilder.append("HTTP/1.1 " + responseMeta.statusCode + " " + responseMeta.statusMessage + "\n");
        Set<Map.Entry<String, String>> responseHeaderSet = responseMeta.headerMap.entrySet();
        for (Map.Entry<String, String> entry : responseHeaderSet) {
            contentBuilder.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        if (null != httpURLConnection.getContentType()) {
            if (httpURLConnection.getContentType().contains("application/json") || httpURLConnection.getContentType().contains("text/") || httpURLConnection.getContentType().contains("charset")) {
                contentBuilder.append("\n" + response.body());
            }
        } else {
            contentBuilder.append("\n[" + responseMeta.httpURLConnection.getContentLength() + "]");
        }
        contentBuilder.append("\n====================================================================");
        return contentBuilder.toString();
    }

    private static String mimeBoundary() {
        StringBuilder mime = new StringBuilder(32);
        Random rand = new Random();
        for (int i = 0; i < 32; ++i) {
            mime.append(mimeBoundaryChars[rand.nextInt(mimeBoundaryChars.length)]);
        }
        return mime.toString();
    }

    private static StringBuilder getBuilder() {
        StringBuilder builder = builderThreadLocal.get();
        if (null == builder) {
            builder = new StringBuilder();
            builderThreadLocal.set(builder);
        }
        builder.setLength(0);
        return builder;
    }
}

