/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.domain;

import cn.schoolwow.quickhttp.QuickHttp;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.time.LocalDateTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickHttpConfig {
    private static Logger logger = LoggerFactory.getLogger(QuickHttpConfig.class);
    public static Proxy proxy;
    private static ExecutorService fileWatchThreadPool;
    private static Path configPath;
    private static Path configResultPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void applyConfiguration() {
        block15: {
            StringBuilder result;
            block14: {
                if (!Files.exists(configPath, new LinkOption[0])) {
                    return;
                }
                result = new StringBuilder();
                byte[] bytes = Files.readAllBytes(configPath);
                String content = new String(bytes, StandardCharsets.UTF_8);
                JSONObject config = JSON.parseObject((String)content);
                if (!config.containsKey((Object)"proxy")) break block14;
                JSONObject proxy = config.getJSONObject("proxy");
                QuickHttpConfig.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getString("host"), proxy.getIntValue("port")));
                result.append(LocalDateTime.now() + " [\u5e94\u7528\u5168\u5c40\u4ee3\u7406]" + QuickHttpConfig.proxy + "\n");
            }
            try {
                if (result.length() > 0) {
                    Files.write(configResultPath, result.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                }
                break block15;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block15;
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    result.append(LocalDateTime.now() + " [\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38]" + e.getMessage() + "\n");
                }
                catch (Throwable throwable) {
                    try {
                        if (result.length() > 0) {
                            Files.write(configResultPath, result.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (result.length() > 0) {
                        Files.write(configResultPath, result.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    static {
        fileWatchThreadPool = Executors.newSingleThreadExecutor();
        configPath = Paths.get(System.getProperty("user.dir") + "/QuickHttpConfig.json", new String[0]);
        configResultPath = Paths.get(System.getProperty("user.dir") + "/QuickHttpConfigResult.txt", new String[0]);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        System.setProperty("sun.net.http.retryPost", "false");
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            configPath.getParent().register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            logger.info("[\u76d1\u542c\u914d\u7f6e\u6587\u4ef6\u8def\u5f84]{}", (Object)configPath);
            fileWatchThreadPool.execute(() -> {
                QuickHttpConfig.applyConfiguration();
                while (true) {
                    try {
                        while (true) {
                            WatchKey watchKey;
                            if ((watchKey = watchService.take()) == null) {
                                return;
                            }
                            for (WatchEvent<?> event : watchKey.pollEvents()) {
                                if (!event.context().toString().equals(configPath.getFileName().toString())) continue;
                                if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                                    try {
                                        Files.deleteIfExists(configResultPath);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    QuickHttp.clientConfig().proxy(null);
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_CREATE && event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                                QuickHttpConfig.applyConfiguration();
                            }
                            watchKey.reset();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.warn("[\u52a0\u8f7d\u76d1\u542c\u670d\u52a1\u5931\u8d25]{}", (Object)e.getMessage());
        }
    }
}

