/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.parser;

import cn.schoolwow.quickhttp.document.element.AbstractElement;
import cn.schoolwow.quickhttp.document.element.Element;
import cn.schoolwow.quickhttp.document.parser.AttributeParser;
import cn.schoolwow.quickhttp.document.parser.HTMLToken;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLTokenParser {
    private Logger logger = LoggerFactory.getLogger(HTMLTokenParser.class);
    private List<HTMLToken> htmlTokenList;
    private AbstractElement root = new AbstractElement();

    public static Element parse(List<HTMLToken> htmlTokenList) {
        AbstractElement root = new HTMLTokenParser(htmlTokenList).root;
        return root;
    }

    private HTMLTokenParser(List<HTMLToken> htmlTokenList) {
        this.htmlTokenList = htmlTokenList;
        this.root.tagName = "ROOT";
        this.parse();
        if (this.root.childList.size() == 1) {
            this.root = this.root.childList.get(0);
        }
    }

    private void parse() {
        AbstractElement current = this.root;
        block9: for (int i = 0; i < this.htmlTokenList.size(); ++i) {
            HTMLToken htmlToken = this.htmlTokenList.get(i);
            switch (htmlToken.tokenType) {
                case openTag: {
                    AbstractElement newElement = new AbstractElement();
                    newElement.parent = current;
                    newElement.parent.childList.add(newElement);
                    newElement.parent.childTextList.add(newElement);
                    current = newElement;
                    continue block9;
                }
                case tagName: {
                    current.tagName = htmlToken.value;
                    continue block9;
                }
                case commentTag: {
                    current.isComment = true;
                    current.ownOriginText = htmlToken.value;
                    current.ownText = this.escapeOwnOriginText(current.ownOriginText);
                    continue block9;
                }
                case attribute: {
                    AttributeParser.parse(htmlToken.value, current.originAttributes);
                    Set<Map.Entry<String, String>> entrySet = current.originAttributes.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        current.attributes.put(entry.getKey(), entry.getValue().replace("\"", "").replace("'", ""));
                    }
                    current.originAttributeText = htmlToken.value;
                    continue block9;
                }
                case openTagClose: {
                    continue block9;
                }
                case textContent: {
                    if (null == current) continue block9;
                    AbstractElement textElement = new AbstractElement();
                    textElement.isTextNode = true;
                    textElement.ownOriginText = htmlToken.value.trim();
                    textElement.ownText = this.escapeOwnOriginText(textElement.ownOriginText);
                    textElement.parent = current;
                    current.childTextList.add(textElement);
                    continue block9;
                }
                case closeTag: {
                    if (htmlToken.value.equals(">") || htmlToken.value.equals("/>")) {
                        current.isSingleNode = true;
                        current = current.parent;
                        continue block9;
                    }
                    if (!"-->".equals(htmlToken.value) && !("</" + current.tagName + ">").equals(htmlToken.value)) continue block9;
                    current = current.parent;
                }
            }
        }
    }

    private String escapeOwnOriginText(String ownOriginText) {
        return ownOriginText.replace("&quot;", "\"").replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&nbsp;", " ");
    }
}

