/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.parser;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeParser {
    private static Logger logger = LoggerFactory.getLogger(AttributeParser.class);
    private char[] chars;
    private int pos = 0;
    private int sectionStart = 0;
    private String currentKey;
    private Map<String, String> attributes;

    public static void parse(String attribute, Map<String, String> attributes) {
        new AttributeParser(attribute, attributes);
    }

    private AttributeParser(String attribute, Map<String, String> attributes) {
        this.attributes = attributes;
        this.chars = attribute.toCharArray();
        this.pos = 0;
        this.sectionStart = 0;
        this.currentKey = null;
        this.parseAttribute();
    }

    private void parseAttribute() {
        State state = null;
        state = this.chars[this.pos] == ' ' ? State.inSpace : State.inKey;
        ++this.pos;
        while (this.pos < this.chars.length) {
            switch (state) {
                case inSpace: {
                    if (this.isKeyValueStart()) {
                        if (this.isLastEqual()) {
                            state = State.inValue;
                            this.sectionStart = this.pos;
                            break;
                        }
                        if (this.currentKey != null) {
                            this.addAttribute(AttributeType.key);
                        }
                        state = State.inKey;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] == '=') {
                        state = State.inEqual;
                        break;
                    }
                    if (this.chars[this.pos] == '\'') {
                        state = State.inSingleQuoteStart;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] == '\"') {
                        state = State.inDoubleQuoteStart;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.pos != this.chars.length - 1) break;
                    this.addAttribute(AttributeType.key);
                    break;
                }
                case inKey: {
                    if (this.pos == this.chars.length - 1) {
                        this.currentKey = new String(this.chars, this.sectionStart, this.pos - this.sectionStart);
                        this.addAttribute(AttributeType.key);
                        break;
                    }
                    if (this.chars[this.pos] == ' ') {
                        this.currentKey = new String(this.chars, this.sectionStart, this.pos - this.sectionStart);
                        state = State.inSpace;
                        break;
                    }
                    if (this.chars[this.pos] != '=') break;
                    this.currentKey = new String(this.chars, this.sectionStart, this.pos - this.sectionStart);
                    state = State.inEqual;
                    break;
                }
                case inEqual: {
                    if (this.chars[this.pos] == ' ') {
                        state = State.inSpace;
                        break;
                    }
                    if (this.isKeyValueStart()) {
                        state = State.inValue;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] == '\'') {
                        state = State.inSingleQuoteStart;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] != '\"') break;
                    state = State.inDoubleQuoteStart;
                    this.sectionStart = this.pos;
                    break;
                }
                case inValue: {
                    if (this.chars[this.pos] != ' ' && this.pos != this.chars.length - 1) break;
                    state = State.inSpace;
                    this.addAttribute(AttributeType.keyValue);
                    break;
                }
                case inSingleQuoteStart: {
                    if (this.pos == this.chars.length - 1) {
                        this.addAttribute(AttributeType.quoteKeyValue);
                        break;
                    }
                    if (this.chars[this.pos] != '\'') break;
                    state = State.inSingleQuoteEnd;
                    break;
                }
                case inSingleQuoteEnd: {
                    if (this.pos == this.chars.length - 1) {
                        this.addAttribute(AttributeType.quoteKeyValue);
                        break;
                    }
                    if (this.chars[this.pos] != ' ') break;
                    state = State.inSpace;
                    this.addAttribute(AttributeType.quoteKeyValue);
                    break;
                }
                case inDoubleQuoteStart: {
                    if (this.pos == this.chars.length - 1) {
                        this.addAttribute(AttributeType.quoteKeyValue);
                        break;
                    }
                    if (this.chars[this.pos] != '\"') break;
                    state = State.inDoubleQuoteEnd;
                    break;
                }
                case inDoubleQuoteEnd: {
                    if (this.chars[this.pos - 1] == '\"') {
                        this.addAttribute(AttributeType.quoteKeyValue);
                    }
                    if (this.chars[this.pos] == ' ') {
                        state = State.inSpace;
                        break;
                    }
                    if (!this.isKeyValueStart()) break;
                    state = State.inKey;
                }
            }
            ++this.pos;
        }
        logger.trace("[\u5c5e\u6027\u5217\u8868]{}", (Object)JSON.toJSONString(this.attributes));
    }

    private void addAttribute(AttributeType attributeType) {
        String value;
        int count = this.pos - this.sectionStart;
        if (this.pos == this.chars.length - 1 && this.chars[this.pos] != ' ') {
            ++count;
        }
        if ((value = new String(this.chars, this.sectionStart, count)).charAt(value.length() - 1) == '=') {
            value = value.substring(0, value.length() - 1);
        }
        if (this.currentKey == null) {
            return;
        }
        switch (attributeType) {
            case key: {
                this.attributes.put(value.trim(), "");
                break;
            }
            case keyValue: 
            case quoteKeyValue: {
                this.attributes.put(this.currentKey.trim(), value);
            }
        }
        this.currentKey = null;
        this.sectionStart = this.pos;
    }

    private boolean isLastEqual() {
        int last;
        if (this.pos == 0) {
            return false;
        }
        for (last = this.pos - 1; last > 0 && this.chars[last] == ' '; --last) {
        }
        return this.chars[last] == '=';
    }

    private boolean isQuoteStartEnd() {
        return this.chars[this.pos] == '\"' || this.chars[this.pos] == '\'';
    }

    private boolean isKeyValueStart() {
        return this.chars[this.pos] == '_' || Character.isLetterOrDigit(this.chars[this.pos]);
    }

    private static enum State {
        inKey,
        inValue,
        inSingleQuoteStart,
        inDoubleQuoteStart,
        inSingleQuoteEnd,
        inDoubleQuoteEnd,
        inSpace,
        inEqual;

    }

    private static enum AttributeType {
        key,
        keyValue,
        quoteKeyValue;

    }
}

