/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.element;

import cn.schoolwow.quickhttp.document.element.Element;
import cn.schoolwow.quickhttp.document.element.Elements;
import cn.schoolwow.quickhttp.document.query.Evaluator;
import cn.schoolwow.quickhttp.document.query.QueryParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class AbstractElement
implements Element {
    private static ThreadLocal<StringBuilder> htmlBuilderThreadLocal = new ThreadLocal();
    private static ThreadLocal<StringBuilder> attributeBuilderThreadLocal = new ThreadLocal();
    public String tagName;
    public boolean isSingleNode;
    public boolean isComment;
    public boolean isTextNode;
    public AbstractElement parent;
    public String originAttributeText;
    public Map<String, String> originAttributes = new HashMap<String, String>();
    public Map<String, String> attributes = new HashMap<String, String>();
    public String ownOriginText;
    public String ownText;
    public List<AbstractElement> childList = new ArrayList<AbstractElement>();
    public List<AbstractElement> childTextList = new ArrayList<AbstractElement>();

    @Override
    public Elements select(String cssQuery) {
        Elements elements = new Elements();
        Evaluator evaluator = QueryParser.parse(cssQuery);
        LinkedList<Element> linkedList = new LinkedList<Element>();
        linkedList.offer(this);
        while (!linkedList.isEmpty()) {
            Element element = (Element)linkedList.poll();
            if (element.tagName() == null) continue;
            if (evaluator.matches(element)) {
                elements.add(element);
            }
            linkedList.addAll(element.childElements());
        }
        return elements;
    }

    @Override
    public Element selectFirst(String cssQuery) {
        return this.select(cssQuery).first();
    }

    @Override
    public Element selectLast(String cssQuery) {
        return this.select(cssQuery).last();
    }

    @Override
    public Map<String, String> attribute() {
        return this.attributes;
    }

    @Override
    public String id() {
        return this.attributes.get("id");
    }

    @Override
    public boolean hasClass(String className) {
        String elementClassName = this.attributes.get("class");
        if (elementClassName == null || elementClassName.isEmpty()) {
            return false;
        }
        String[] classNames = new String[]{className};
        if (className.contains(".")) {
            classNames = className.split("\\.");
        }
        for (String _className : classNames) {
            if (elementClassName.contains(_className)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAttr(String attributeKey) {
        return this.attributes.containsKey(attributeKey);
    }

    @Override
    public String attr(String attributeKey) {
        String value = this.attributes.get(attributeKey);
        if (null != value) {
            value = value.replace("\"", "").replace("'", "");
        }
        return value;
    }

    @Override
    public void attr(String attributeKey, String attributeValue) {
        this.originAttributes.put(attributeKey, attributeValue);
        this.attributes.put(attributeKey, attributeValue);
    }

    @Override
    public void clearAttributes() {
        this.originAttributes.clear();
        this.attributes.clear();
    }

    @Override
    public String tagName() {
        return this.tagName;
    }

    @Override
    public String text() {
        Elements elements = this.textElement();
        StringBuilder builder = htmlBuilderThreadLocal.get();
        builder.setLength(0);
        for (Element element : elements) {
            builder.append(element.ownText());
        }
        return builder.toString();
    }

    @Override
    public Elements textElement() {
        Stack<AbstractElement> stack = new Stack<AbstractElement>();
        stack.push(this);
        Elements elements = new Elements();
        while (!stack.isEmpty()) {
            AbstractElement abstractElement = (AbstractElement)stack.pop();
            if (abstractElement.isTextNode) {
                elements.add(abstractElement);
            }
            for (int i = abstractElement.childTextList.size() - 1; i >= 0; --i) {
                stack.push(abstractElement.childTextList.get(i));
            }
        }
        return elements;
    }

    @Override
    public String html() {
        StringBuilder builder = htmlBuilderThreadLocal.get();
        builder.setLength(0);
        for (AbstractElement child : this.childTextList) {
            this.getHtmlRecursive(child, builder);
        }
        return builder.toString();
    }

    @Override
    public String ownText() {
        if (this.isSingleNode || this.isComment || this.isTextNode) {
            return this.ownText;
        }
        StringBuilder builder = htmlBuilderThreadLocal.get();
        builder.setLength(0);
        for (AbstractElement abstractElement : this.childTextList) {
            if (!abstractElement.isTextNode) continue;
            builder.append(abstractElement.ownOriginText);
        }
        return builder.toString();
    }

    @Override
    public String outerHtml() {
        StringBuilder builder = htmlBuilderThreadLocal.get();
        builder.setLength(0);
        if (null != this.tagName && this.tagName.equals("ROOT")) {
            for (AbstractElement child : this.childTextList) {
                this.getHtmlRecursive(child, builder);
            }
        } else {
            this.getHtmlRecursive(this, builder);
        }
        return builder.toString();
    }

    @Override
    public String prettyOuterHtml() {
        StringBuilder builder = htmlBuilderThreadLocal.get();
        builder.setLength(0);
        if (null != this.tagName && this.tagName.equals("ROOT")) {
            for (AbstractElement child : this.childTextList) {
                this.getHtmlRecursivePretty(child, builder);
            }
        } else {
            this.getHtmlRecursivePretty(this, builder);
        }
        return builder.toString();
    }

    @Override
    public String val() {
        if ("textarea".equals(this.tagName)) {
            return this.text();
        }
        if (this.hasAttr("value")) {
            return this.attr("value");
        }
        return null;
    }

    @Override
    public Element parent() {
        return this.parent;
    }

    @Override
    public Elements children() {
        Elements elements = new Elements();
        elements.addAll(this.childList);
        return elements;
    }

    @Override
    public Element firstChild() {
        if (this.childList.isEmpty()) {
            return null;
        }
        return this.childList.get(0);
    }

    @Override
    public Element lastChild() {
        if (this.childList.isEmpty()) {
            return null;
        }
        return this.childList.get(this.childList.size() - 1);
    }

    @Override
    public Element childElement(int index) {
        if (index < 1 || index > this.childList.size()) {
            return null;
        }
        return this.childList.get(index - 1);
    }

    @Override
    public Elements childElements() {
        Elements elements = new Elements(this.childList.size());
        elements.addAll(this.childList);
        return elements;
    }

    @Override
    public Elements siblingElements() {
        Elements elements = new Elements();
        for (Element element : this.parent.childList) {
            if (element == this) continue;
            elements.add(element);
        }
        return elements;
    }

    @Override
    public Element previousElementSibling() {
        int pos = this.elementSiblingIndex();
        if (pos - 1 >= 0) {
            return this.parent.childList.get(pos - 1);
        }
        return null;
    }

    @Override
    public Element nextElementSibling() {
        int pos = this.elementSiblingIndex();
        if (pos + 1 < this.parent.childList.size()) {
            return this.parent.childList.get(pos + 1);
        }
        return null;
    }

    @Override
    public int elementSiblingIndex() {
        if (null == this.parent) {
            return 0;
        }
        for (int i = 0; i < this.parent.childList.size(); ++i) {
            if (this.parent.childList.get(i) != this) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Elements getAllElements() {
        Stack<AbstractElement> stack = new Stack<AbstractElement>();
        if (this.tagName.equals("ROOT")) {
            for (AbstractElement child : this.childList) {
                stack.push(child);
            }
        } else {
            stack.push(this);
        }
        Elements elements = new Elements();
        while (!stack.isEmpty()) {
            AbstractElement abstractElement = (AbstractElement)stack.pop();
            elements.add(abstractElement);
            for (int i = abstractElement.childList.size() - 1; i >= 0; --i) {
                stack.push(abstractElement.childList.get(i));
            }
        }
        return elements;
    }

    @Override
    public Element remove() {
        this.parent.childList.remove(this);
        this.parent.childTextList.remove(this);
        return this;
    }

    public String toString() {
        String attribute = this.getAttribute(this);
        if (this.isComment) {
            return "<!--" + this.ownText + "-->";
        }
        if (this.isTextNode) {
            return this.ownOriginText;
        }
        if (this.isSingleNode) {
            return "<" + this.tagName + " " + attribute + "/>";
        }
        return "<" + this.tagName + " " + attribute + "></" + this.tagName + ">";
    }

    private void getHtmlRecursivePretty(AbstractElement abstractElement, StringBuilder builder) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StringBuilder tabBuilder = attributeBuilderThreadLocal.get();
        tabBuilder.setLength(0);
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (!stackTraceElement.getMethodName().equals("getHtmlRecursive")) continue;
            tabBuilder.append("\t");
        }
        String tab = tabBuilder.toString();
        String attribute = this.getAttribute(abstractElement);
        if (abstractElement.isComment) {
            builder.append(tab + "<!--" + abstractElement.ownOriginText + "-->\n");
        } else if (abstractElement.isTextNode) {
            builder.append(abstractElement.ownOriginText);
        } else if (abstractElement.isSingleNode) {
            builder.append(tab + "<" + abstractElement.tagName + attribute);
            if (!abstractElement.tagName.startsWith("!") && !abstractElement.tagName.startsWith("?")) {
                builder.append("/");
            }
            builder.append(">\n");
        } else {
            builder.append(tab + "<" + abstractElement.tagName + attribute + ">\n");
            for (AbstractElement child : abstractElement.childTextList) {
                this.getHtmlRecursive(child, builder);
            }
            builder.append("\n" + tab + "</" + abstractElement.tagName + ">\n");
        }
    }

    private void getHtmlRecursive(AbstractElement abstractElement, StringBuilder builder) {
        String attribute = this.getAttribute(abstractElement);
        if (abstractElement.isComment) {
            builder.append("<!--" + abstractElement.ownOriginText + "-->");
        } else if (abstractElement.isTextNode) {
            builder.append(abstractElement.ownOriginText);
        } else if (abstractElement.isSingleNode) {
            builder.append("<" + abstractElement.tagName + attribute);
            if (!abstractElement.tagName.startsWith("!") && !abstractElement.tagName.startsWith("?")) {
                builder.append("/");
            }
            builder.append(">");
        } else {
            builder.append("<" + abstractElement.tagName + attribute + ">");
            for (AbstractElement child : abstractElement.childTextList) {
                this.getHtmlRecursive(child, builder);
            }
            builder.append("</" + abstractElement.tagName + ">");
        }
    }

    private String getAttribute(AbstractElement abstractElement) {
        StringBuilder builder = attributeBuilderThreadLocal.get();
        builder.setLength(0);
        Set<Map.Entry<String, String>> entrySet = abstractElement.originAttributes.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            builder.append(" " + entry.getKey());
            if (entry.getValue().isEmpty()) continue;
            builder.append("=" + entry.getValue());
        }
        return builder.toString();
    }

    static {
        htmlBuilderThreadLocal.set(new StringBuilder());
        attributeBuilderThreadLocal.set(new StringBuilder());
    }
}

