/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.util;

import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.dto.FlowContextDataRange;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.flow.HasFlowConfig;
import cn.schoolwow.quickflow.listener.LoadFlowConfig;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;

public class QuickFlowConfigUtil {
    public static void handleHasFlowConfig(BusinessFlow businessFlow, FlowExecutorConfig flowExecutorConfig) {
        if (!(businessFlow instanceof HasFlowConfig)) {
            return;
        }
        HasFlowConfig hasFlowConfig = (HasFlowConfig)((Object)businessFlow);
        QuickFlowConfigUtil.setFlowConfigData(businessFlow.name(), hasFlowConfig, flowExecutorConfig);
    }

    public static void handleHasFlowConfig(CompositeBusinessFlow compositeBusinessFlow, FlowExecutorConfig flowExecutorConfig) {
        if (!(compositeBusinessFlow instanceof HasFlowConfig)) {
            return;
        }
        HasFlowConfig hasFlowConfig = (HasFlowConfig)((Object)compositeBusinessFlow);
        QuickFlowConfigUtil.setFlowConfigData(compositeBusinessFlow.name(), hasFlowConfig, flowExecutorConfig);
    }

    public static void handleLoadFlowConfig(BusinessFlow businessFlow, FlowExecutorConfig flowExecutorConfig) {
        if (!(businessFlow instanceof LoadFlowConfig)) {
            return;
        }
        LoadFlowConfig loadFlowConfig = (LoadFlowConfig)((Object)businessFlow);
        QuickFlowConfigUtil.handleLoadFlowConfig(loadFlowConfig, flowExecutorConfig);
    }

    public static void handleLoadFlowConfig(CompositeBusinessFlow compositeBusinessFlow, FlowExecutorConfig flowExecutorConfig) {
        if (!(compositeBusinessFlow instanceof LoadFlowConfig)) {
            return;
        }
        LoadFlowConfig loadFlowConfig = (LoadFlowConfig)((Object)compositeBusinessFlow);
        QuickFlowConfigUtil.handleLoadFlowConfig(loadFlowConfig, flowExecutorConfig);
    }

    public static void loadFlowConfigByName(String name, FlowExecutorConfig flowExecutorConfig) {
        FlowConfig flowConfig = flowExecutorConfig.flowExecutorRootConfig.flowConfig;
        if (flowConfig.flowConfigDataContext.flowConfigDataMap.containsKey(name)) {
            JSONObject requestData = flowConfig.flowConfigDataContext.flowConfigDataMap.get(name);
            for (String key : requestData.keySet()) {
                Object value = requestData.get((Object)key);
                flowExecutorConfig.flowContext.putFlowContextData(key, value, FlowContextDataRange.Flow, FlowDataFeature.FlowConfigData);
            }
        }
    }

    private static void setFlowConfigData(String flowName, HasFlowConfig hasFlowConfig, FlowExecutorConfig flowExecutorConfig) {
        FlowConfig flowConfig = flowExecutorConfig.flowExecutorRootConfig.flowConfig;
        JSONObject requestData = new JSONObject();
        if (flowConfig.flowConfigDataContext.flowConfigDataMap.containsKey(flowName)) {
            requestData.putAll((Map)flowConfig.flowConfigDataContext.flowConfigDataMap.get(flowName));
        } else {
            hasFlowConfig.setRequestData(requestData);
            flowConfig.flowConfigDataContext.flowConfigDataMap.put(flowName, requestData);
            if (null != flowConfig.flowConfigHandlerContext.flowConfigRequestDataHandler) {
                try {
                    flowConfig.flowConfigHandlerContext.flowConfigRequestDataHandler.saveFlowConfigRequestData(hasFlowConfig.flowConfigCategoryName(), flowName, requestData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (String key : requestData.keySet()) {
            Object value = requestData.get((Object)key);
            flowExecutorConfig.flowContext.putFlowContextData(key, value, FlowContextDataRange.Flow, FlowDataFeature.FlowConfigData);
        }
    }

    private static void handleLoadFlowConfig(LoadFlowConfig loadFlowConfig, FlowExecutorConfig flowExecutorConfig) {
        HasFlowConfig[] hasFlowConfigArray;
        for (HasFlowConfig hasFlowConfig : hasFlowConfigArray = loadFlowConfig.getHasFlowConfigArray()) {
            String name;
            if (hasFlowConfig instanceof CompositeBusinessFlow) {
                CompositeBusinessFlow compositeBusinessFlow = (CompositeBusinessFlow)((Object)hasFlowConfig);
                name = compositeBusinessFlow.name();
                QuickFlowConfigUtil.loadFlowConfigByName(name, flowExecutorConfig);
            }
            if (!(hasFlowConfig instanceof BusinessFlow)) continue;
            BusinessFlow flowConfigBusinessFlow = (BusinessFlow)((Object)hasFlowConfig);
            name = flowConfigBusinessFlow.name();
            QuickFlowConfigUtil.loadFlowConfigByName(name, flowExecutorConfig);
        }
    }
}

