/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.service.flowContext.getData;

import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.dto.FlowContextDataRange;
import cn.schoolwow.quickflow.service.flowContext.getData.FlowContextGetDataOperation;
import cn.schoolwow.quickflow.service.flowContext.putData.FlowContextPutDataOperation;
import cn.schoolwow.quickflow.util.QuickFlowUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FlowContextGetDataOperationImpl
implements FlowContextGetDataOperation {
    private static final FlowContextDataRange[] ranges = new FlowContextDataRange[]{FlowContextDataRange.ThreadLocal, FlowContextDataRange.CurrentFlow, FlowContextDataRange.CurrentCompositeBusiness, FlowContextDataRange.Flow, FlowContextDataRange.ContextThreadLocal, FlowContextDataRange.Context};
    private FlowExecutorConfig flowExecutorConfig;
    private FlowContextPutDataOperation flowContextPutDataOperation;

    public FlowContextGetDataOperationImpl(FlowExecutorConfig flowExecutorConfig, FlowContextPutDataOperation flowContextPutDataOperation) {
        this.flowExecutorConfig = flowExecutorConfig;
        this.flowContextPutDataOperation = flowContextPutDataOperation;
    }

    @Override
    public FlowContext isDataNotExist(String key, String message) {
        if (!this.containKey(key)) {
            throw new IllegalArgumentException(message);
        }
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public boolean containKey(String key) {
        Object value = this.getData(key);
        return null != value;
    }

    @Override
    public boolean containInstanceKey(Class clazz) {
        Object value = this.getInstanceData(clazz);
        return null != value;
    }

    @Override
    public Object checkData(String key) {
        Object value = this.getData(key);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public <T> T checkData(String key, Class<T> clazz) {
        T value = this.getData(key, clazz);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public <T> T checkData(String key, TypeReference<T> typeReference) {
        T value = this.getData(key, typeReference);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public <T> T checkInstanceData(Class<T> clazz) {
        String key = clazz.getName();
        T value = this.getData(key, clazz);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public Object getData(String key) {
        for (FlowContextDataRange flowContextDataRange : ranges) {
            Object value = this.getDataFromRange(key, flowContextDataRange);
            if (null == value) continue;
            return value;
        }
        return null;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz) {
        Object value = this.getData(key);
        return QuickFlowUtil.convertToClassType(value, clazz);
    }

    @Override
    public <T> T getData(String key, TypeReference<T> typeReference) {
        Object value = this.getData(key);
        if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            return (T)object.toJavaObject(typeReference);
        }
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            return (T)array.toJavaObject(typeReference);
        }
        return (T)value;
    }

    @Override
    public Object getData(String key, Object defaultValue) {
        Object value = this.getData(key);
        if (null == value) {
            this.flowContextPutDataOperation.putTemporaryData(key, defaultValue);
            return defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz, T defaultValue) {
        T value = this.getData(key, clazz);
        if (null == value) {
            this.flowContextPutDataOperation.putTemporaryData(key, defaultValue);
            return defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getInstanceData(Class<T> clazz) {
        String key = clazz.getName();
        return this.getData(key, clazz);
    }

    @Override
    public <T> T getInstanceData(Class<T> clazz, T defaultValue) {
        String key = clazz.getName();
        return this.getData(key, clazz, defaultValue);
    }

    @Override
    public Map<String, Object> getContextDataMap() {
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        FlowConfig flowConfig = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig;
        Map<String, Object> dataMap = flowConfig.flowConfigDataContext.dataMap;
        filterDataMap.putAll(dataMap);
        this.removeEntryByKeySet(filterDataMap, flowConfig.flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet);
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getFlowConfigDataMap() {
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        Map<String, Object> dataMap = this.flowExecutorConfig.flowExecutorRootConfig.dataMap;
        this.addEntryByKeySet(filterDataMap, dataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.flowConfigDataKeySet);
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getFlowExecuteDataMap() {
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        Map<String, Object> dataMap = this.flowExecutorConfig.flowExecutorRootConfig.dataMap;
        filterDataMap.putAll(dataMap);
        Map<String, Object> threadLocalDataMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
        if (null != threadLocalDataMap) {
            filterDataMap.putAll(threadLocalDataMap);
        }
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.keySet());
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet);
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.requestDataKeySet);
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.temporaryDataKeySet);
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet);
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getRequestDataMap() {
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        Map<String, Object> dataMap = this.flowExecutorConfig.flowExecutorRootConfig.dataMap;
        for (String key : this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.requestDataKeySet) {
            if (!dataMap.containsKey(key) || this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.temporaryDataKeySet.contains(key)) continue;
            filterDataMap.put(key, dataMap.get(key));
        }
        Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.threadLocalDataMap.get();
        if (null != threadLocalMap) {
            Set<String> temporaryDataKeySet = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet;
            for (String key : threadLocalMap.keySet()) {
                if (temporaryDataKeySet.contains(key)) continue;
                filterDataMap.put(key, threadLocalMap.get(key));
            }
        }
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getThreadLocalDataMap() {
        Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
        return threadLocalMap;
    }

    @Override
    public Map<String, Object> getCurrentFlowDataMap() {
        Map<String, Object> currentFlowData = this.flowExecutorConfig.currentFlowDataMap;
        return currentFlowData;
    }

    @Override
    public Map<String, Object> getCurrentCompositeFlowDataMap() {
        return this.flowExecutorConfig.currentCompositeFlowDataMap;
    }

    @Override
    public FlowContextDataRange getFlowContextDataRangeByKey(String key) {
        Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
        if (null != threadLocalMap && !threadLocalMap.isEmpty() && threadLocalMap.containsKey(key)) {
            return FlowContextDataRange.ThreadLocal;
        }
        Map<String, Object> currentFlowDataMap = this.flowExecutorConfig.currentFlowDataMap;
        if (!currentFlowDataMap.isEmpty() && currentFlowDataMap.containsKey(key)) {
            return FlowContextDataRange.CurrentFlow;
        }
        Map<String, Object> currentCompositeFlowDataMap = this.flowExecutorConfig.currentCompositeFlowDataMap;
        if (!currentCompositeFlowDataMap.isEmpty() && currentCompositeFlowDataMap.containsKey(key)) {
            return FlowContextDataRange.CurrentCompositeBusiness;
        }
        if (!this.flowExecutorConfig.flowExecutorRootConfig.dataMap.isEmpty() && this.flowExecutorConfig.flowExecutorRootConfig.dataMap.containsKey(key)) {
            return FlowContextDataRange.Context;
        }
        Map<String, Object> contextThreadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.threadLocalDataMap.get();
        if (null != contextThreadLocalMap && !contextThreadLocalMap.isEmpty() && contextThreadLocalMap.containsKey(key)) {
            return FlowContextDataRange.ContextThreadLocal;
        }
        Map<String, Object> contextDataMap = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap;
        if (!contextDataMap.isEmpty() && contextDataMap.containsKey(key)) {
            return FlowContextDataRange.Context;
        }
        return null;
    }

    @Override
    public FlowContextDataRange getFlowContextDataRangeByInstance(Class clazz) {
        return this.getFlowContextDataRangeByKey(clazz.getName());
    }

    @Override
    public void printFlowDataRange() {
        Map<String, Object> contextThreadLocalMap;
        Map<String, Object> currentCompositeFlowDataMap;
        Map<String, Object> currentFlowDataMap;
        StringBuilder builder = new StringBuilder();
        Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
        if (null != threadLocalMap && !threadLocalMap.isEmpty()) {
            builder.append("\u5f53\u524d\u7ebf\u7a0b\u4e0a\u4e0b\u6587:" + threadLocalMap.keySet() + "\r\n");
        }
        if (!(currentFlowDataMap = this.flowExecutorConfig.currentFlowDataMap).isEmpty()) {
            builder.append("\u5f53\u524d\u6d41\u7a0b:" + currentFlowDataMap.keySet() + "\r\n");
        }
        if (!(currentCompositeFlowDataMap = this.flowExecutorConfig.currentCompositeFlowDataMap).isEmpty()) {
            builder.append("\u5f53\u524d\u590d\u5408\u6d41\u7a0b:" + currentCompositeFlowDataMap.keySet() + "\r\n");
        }
        if (!this.flowExecutorConfig.flowExecutorRootConfig.dataMap.isEmpty()) {
            builder.append("\u6d41\u7a0b\u4e0a\u4e0b\u6587:" + this.flowExecutorConfig.flowExecutorRootConfig.dataMap.keySet() + "\r\n");
        }
        if (null != (contextThreadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.threadLocalDataMap.get()) && !contextThreadLocalMap.isEmpty()) {
            builder.append("\u5168\u5c40\u6d41\u7a0b\u7ebf\u7a0b\u4e0a\u4e0b\u6587:" + contextThreadLocalMap.keySet() + "\r\n");
        }
        if (!this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.isEmpty()) {
            builder.append("\u5168\u5c40\u6d41\u7a0b\u4e0a\u4e0b\u6587:" + this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.keySet() + "\r\n");
        }
        System.out.println(builder);
    }

    private void checkValueEmpty(String key, Object value) {
        if (null == value) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void addEntryByKeySet(Map<String, Object> filterDataMap, Map<String, Object> dataMap, Set<String> keySet) {
        for (String key : keySet) {
            filterDataMap.put(key, dataMap.get(key));
        }
    }

    private void removeEntryByKeySet(Map<String, Object> dataMap, Set<String> keySet) {
        for (String key : keySet) {
            dataMap.remove(key);
        }
    }

    private Object getDataFromRange(String key, FlowContextDataRange flowContextDataRange) {
        switch (flowContextDataRange) {
            case ThreadLocal: {
                Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
                if (null == threadLocalMap || !threadLocalMap.containsKey(key)) break;
                Object value = threadLocalMap.get(key);
                return value;
            }
            case CurrentFlow: {
                Map<String, Object> currentFlowDataMap = this.flowExecutorConfig.currentFlowDataMap;
                if (null == currentFlowDataMap || !currentFlowDataMap.containsKey(key)) break;
                return currentFlowDataMap.get(key);
            }
            case CurrentCompositeBusiness: {
                Map<String, Object> currentCompositeFlowDataMap = this.flowExecutorConfig.currentCompositeFlowDataMap;
                if (null == currentCompositeFlowDataMap || !currentCompositeFlowDataMap.containsKey(key)) break;
                return currentCompositeFlowDataMap.get(key);
            }
            case Flow: {
                if (!this.flowExecutorConfig.flowExecutorRootConfig.dataMap.containsKey(key)) break;
                Object value = this.flowExecutorConfig.flowExecutorRootConfig.dataMap.get(key);
                if (this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet.contains(key)) {
                    this.flowContextPutDataOperation.removeData(key);
                    this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet.remove(key);
                }
                return value;
            }
            case ContextThreadLocal: {
                Map<String, Object> contextThreadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.threadLocalDataMap.get();
                if (null == contextThreadLocalMap || !contextThreadLocalMap.containsKey(key)) break;
                return contextThreadLocalMap.get(key);
            }
            case Context: {
                if (!this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.containsKey(key)) break;
                return this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.get(key);
            }
        }
        return null;
    }
}

