/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.service.flowContext.execute;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentCompositeBusinessException;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.exception.QuickFlowRuntimeException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;
import cn.schoolwow.quickflow.service.flowContext.execute.FlowContextExecuteOperation;
import cn.schoolwow.quickflow.util.QuickFlowUtil;
import java.util.HashMap;

public class FlowContextExecuteOperationImpl
implements FlowContextExecuteOperation {
    private FlowExecutorConfig flowExecutorConfig;

    public FlowContextExecuteOperationImpl(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    @Override
    public void brokenCurrentFlow(String reason) {
        throw new BrokenCurrentFlowException(reason);
    }

    @Override
    public void brokenCurrentCompositeBusiness(String reason) {
        throw new BrokenCurrentCompositeBusinessException(reason);
    }

    @Override
    public void broken(String reason) {
        this.flowExecutorConfig.flowExecutorRootConfig.brokenReason = reason;
        throw new BrokenException(reason);
    }

    @Override
    public QuickFlowExecutor startFlow(String name) {
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = QuickFlowUtil.getFlowContextInvocationHandler(flowExecutorConfig);
        HashMap<String, Object> currentCompositeFlowDataMap = new HashMap<String, Object>();
        if (null != this.flowExecutorConfig.currentCompositeFlowDataMap) {
            currentCompositeFlowDataMap.putAll(this.flowExecutorConfig.currentCompositeFlowDataMap);
        }
        flowExecutorConfig.currentCompositeFlowDataMap = currentCompositeFlowDataMap;
        flowExecutorConfig.parentFlowExecutorConfig = this.flowExecutorConfig;
        flowExecutorConfig.flowExecutorRootConfig = this.flowExecutorConfig.flowExecutorRootConfig;
        return QuickFlowUtil.getQuickFlowExecutorInvocationHandler(flowExecutorConfig);
    }

    @Override
    public QuickFlowExecutor startFlow(BusinessFlow businessFlow) {
        return this.startFlow(businessFlow.name()).next(businessFlow);
    }

    @Override
    public QuickFlowExecutor startFlow(CompositeBusinessFlow compositeBusinessFlow) {
        return QuickFlowUtil.getCompositeQuickFlowExecutor(compositeBusinessFlow, this.flowExecutorConfig);
    }

    @Override
    public FlowContext executeFunctionFlowList(String ... functionFlowNames) {
        for (String functionFlowName : functionFlowNames) {
            FunctionFlow functionFlow = (FunctionFlow)this.flowExecutorConfig.flowContext.checkData(functionFlowName);
            try {
                functionFlow.executeFunction(this.flowExecutorConfig.flowContext);
            }
            catch (BrokenException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QuickFlowRuntimeException(e);
            }
        }
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public FlowContext executeFlowList(BusinessFlow ... businessFlowList) {
        Boolean printTrace = this.flowExecutorConfig.printTrace;
        try {
            this.flowExecutorConfig.printTrace = false;
            for (BusinessFlow businessFlow : businessFlowList) {
                try {
                    businessFlow.executeBusinessFlow(this.flowExecutorConfig.flowContext);
                }
                catch (BrokenCurrentFlowException e) {
                    this.flowExecutorConfig.printFlowTraceWithIndex("|[x]|" + businessFlow.name() + "|\u5f53\u524d\u6d41\u7a0b\u4e2d\u65ad|\u4e2d\u65ad\u539f\u56e0:" + e.getReason() + this.flowExecutorConfig.getRemarkBuilder().toString());
                }
            }
        }
        catch (BrokenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuickFlowRuntimeException(e);
        }
        finally {
            this.flowExecutorConfig.printTrace = printTrace;
        }
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public FlowContext executeCompositeFlowList(CompositeBusinessFlow ... compositeBusinessFlowList) {
        BusinessFlow[] businessFlowArray = new BusinessFlow[compositeBusinessFlowList.length];
        for (int i = 0; i < compositeBusinessFlowList.length; ++i) {
            businessFlowArray[i] = QuickFlowUtil.getBusinessFlow(compositeBusinessFlowList[i]);
        }
        this.executeFlowList(businessFlowArray);
        return this.flowExecutorConfig.flowContext;
    }
}

