/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorRootConfig;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlowExecutorConfig {
    public String name;
    public String currentFlowName;
    public FlowContext flowContext;
    public Boolean printTrace;
    public Boolean ignoreBroken;
    public Boolean ignoreException;
    public BusinessFlow currentFlow;
    public List<BusinessFlow> flowList = new ArrayList<BusinessFlow>();
    public Map<String, Object> currentFlowDataMap = new ConcurrentHashMap<String, Object>();
    public Map<String, Object> currentCompositeFlowDataMap = new ConcurrentHashMap<String, Object>();
    public SingleFlowListener singleFlowListener;
    public TryCatchFinallyHandler tryCatchFinallyHandler;
    public FlowExecutorConfig parentFlowExecutorConfig;
    public FlowExecutorRootConfig flowExecutorRootConfig;
    public QuickFlowExecutor quickFlowExecutor;
    public boolean compositeBusiness;

    public boolean shouldPrintTrace() {
        if (this.flowExecutorRootConfig.flowConfig.flowConfigSwitcherContext.debug) {
            return true;
        }
        Boolean shouldPrintTrace = this.printTrace;
        if (null == shouldPrintTrace) {
            Integer flowLevel;
            shouldPrintTrace = this.flowExecutorRootConfig.flowConfig.flowConfigSwitcherContext.printTrace ? ((flowLevel = this.getFlowLevel()) <= this.flowExecutorRootConfig.flowConfig.flowConfigSwitcherContext.traceLevel ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
        }
        return shouldPrintTrace;
    }

    public void printFlowTrace(String content) {
        boolean shouldPrintTrace = this.shouldPrintTrace();
        if (shouldPrintTrace) {
            this.printTrace(content);
        }
    }

    public void printFlowTraceWithIndex(String content) {
        boolean shouldPrintTrace = this.shouldPrintTrace();
        if (shouldPrintTrace) {
            content = "[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + content;
            this.printTrace(content);
        }
    }

    public StringBuilder getRemarkBuilder() {
        StringBuilder remarkBuilder = this.flowExecutorRootConfig.remarkBuilderThreadLocal.get();
        if (null == remarkBuilder) {
            this.flowExecutorRootConfig.remarkBuilderThreadLocal.set(new StringBuilder());
        }
        return this.flowExecutorRootConfig.remarkBuilderThreadLocal.get();
    }

    public void recordContent(String content) {
        if (this.flowExecutorRootConfig.startRecord) {
            this.flowExecutorRootConfig.recordBuilder.append("[" + this.name + "]" + content + "\r\n");
        }
    }

    private void printTrace(String content) {
        Integer flowLevel = this.getFlowLevel();
        for (int i = 0; i < flowLevel; ++i) {
            this.flowExecutorRootConfig.printTraceBuilder.append("\t");
        }
        this.flowExecutorRootConfig.printTraceBuilder.append(content + "\r\n");
        if (this.flowExecutorRootConfig.flowConfig.flowConfigSwitcherContext.debug) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < flowLevel; ++i) {
                builder.append("\t");
            }
            builder.append("\u3010" + flowLevel + "\u3011" + content);
            System.out.println(builder.toString());
        }
    }

    public Integer getFlowLevel() {
        Integer flowLevel = this.flowExecutorRootConfig.flowLevel.get();
        if (null == flowLevel) {
            flowLevel = 0;
            this.flowExecutorRootConfig.flowLevel.set(flowLevel);
        }
        return flowLevel;
    }
}

