/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.util;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.service.flowContext.FlowContextInvocationHandler;
import cn.schoolwow.quickflow.util.QuickFlowConfigUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;

public class QuickFlowUtil {
    public static String getInstanceClassName(Object instance) {
        return instance.getClass().getName();
    }

    public static FlowContext getFlowContextInvocationHandler(FlowExecutorConfig flowExecutorConfig) {
        FlowContext flowContext;
        FlowContextInvocationHandler flowContextInvocationHandler = new FlowContextInvocationHandler(flowExecutorConfig);
        flowExecutorConfig.flowContext = flowContext = (FlowContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{FlowContext.class}, (InvocationHandler)flowContextInvocationHandler);
        return flowContext;
    }

    public static JSONArray getFlowArray(FlowExecutorConfig flowExecutorConfig) {
        JSONObject flow;
        JSONArray flowArray = new JSONArray();
        if (null != flowExecutorConfig.tryCatchFinallyHandler) {
            flow = new JSONObject();
            flow.put("\u540d\u79f0", (Object)flowExecutorConfig.tryCatchFinallyHandler.name());
            flow.put("\u7c7b\u578b", (Object)"\u5904\u7406\u5668");
            flow.put("\u5904\u7406\u5668\u7c7b\u578b", (Object)"TryCatchFinally");
            flowArray.add((Object)flow);
        }
        if (null != flowExecutorConfig.singleFlowListener) {
            flow = new JSONObject();
            flow.put("\u540d\u79f0", (Object)flowExecutorConfig.singleFlowListener.name());
            flow.put("\u7c7b\u578b", (Object)"\u5904\u7406\u5668");
            flow.put("\u5904\u7406\u5668\u7c7b\u578b", (Object)"SingleFlow");
            flowArray.add((Object)flow);
        }
        for (BusinessFlow businessFlow : flowExecutorConfig.flowList) {
            JSONObject flow2 = new JSONObject();
            flow2.put("\u540d\u79f0", (Object)businessFlow.name());
            flow2.put("\u7c7b\u578b", (Object)"\u666e\u901a\u6d41\u7a0b");
            flowArray.add((Object)flow2);
        }
        return flowArray;
    }

    public static QuickFlowExecutor getCompositeQuickFlowExecutor(CompositeBusinessFlow compositeBusinessFlow, FlowExecutorConfig flowExecutorConfig) {
        FlowExecutorConfig compositeFlowExecutorConfig = new FlowExecutorConfig();
        compositeFlowExecutorConfig.name = compositeBusinessFlow.name();
        compositeFlowExecutorConfig.flowContext = QuickFlowUtil.getFlowContextInvocationHandler(compositeFlowExecutorConfig);
        compositeFlowExecutorConfig.currentCompositeFlowDataMap = new ConcurrentHashMap<String, Object>();
        compositeFlowExecutorConfig.currentCompositeFlowDataMap.putAll(flowExecutorConfig.currentCompositeFlowDataMap);
        if (null != flowExecutorConfig.parentFlowExecutorConfig) {
            compositeFlowExecutorConfig.currentCompositeFlowDataMap.putAll(flowExecutorConfig.parentFlowExecutorConfig.currentCompositeFlowDataMap);
        }
        compositeFlowExecutorConfig.flowExecutorRootConfig = flowExecutorConfig.flowExecutorRootConfig;
        compositeFlowExecutorConfig.compositeBusiness = true;
        QuickFlowExecutor compositeQuickFlowExecutor = new QuickFlowExecutor(compositeFlowExecutorConfig);
        compositeBusinessFlow.executeCompositeBusiness(compositeQuickFlowExecutor);
        QuickFlowConfigUtil.loadFlowConfigByName(compositeBusinessFlow.name(), flowExecutorConfig);
        return compositeQuickFlowExecutor;
    }

    public static BusinessFlow getBusinessFlow(final CompositeBusinessFlow compositeBusinessFlow) {
        final String compositeFlowName = "[\u590d\u5408\u6d41\u7a0b]" + compositeBusinessFlow.name();
        BusinessFlow businessFlow = new BusinessFlow(){

            @Override
            public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                FlowExecutorConfig flowExecutorConfig = flowContext.getFlowExecutorConfig();
                QuickFlowExecutor compositeQuickFlowExecutor = QuickFlowUtil.getCompositeQuickFlowExecutor(compositeBusinessFlow, flowExecutorConfig);
                compositeQuickFlowExecutor.execute();
            }

            @Override
            public String name() {
                return compositeFlowName;
            }
        };
        return businessFlow;
    }
}

