/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.service.quickFlow.execute;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.domain.FlowExecutorRootConfig;
import cn.schoolwow.quickflow.dto.FlowContextDataRange;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import cn.schoolwow.quickflow.service.quickFlow.execute.QuickFlowExecuteOperation;
import cn.schoolwow.quickflow.util.QuickFlowConfigUtil;
import cn.schoolwow.quickflow.util.QuickFlowUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class QuickFlowExecuteOperationImpl
implements QuickFlowExecuteOperation {
    private FlowConfig flowConfig;

    public QuickFlowExecuteOperationImpl(FlowConfig flowConfig) {
        this.flowConfig = flowConfig;
    }

    @Override
    public QuickFlowExecutor startFlow(String name) {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u4e3b\u6d41\u7a0b\u540d\u79f0!");
        }
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = QuickFlowUtil.getFlowContextInvocationHandler(flowExecutorConfig);
        flowExecutorConfig.currentCompositeFlowDataMap = new ConcurrentHashMap<String, Object>();
        if (null != flowExecutorConfig.parentFlowExecutorConfig) {
            flowExecutorConfig.currentCompositeFlowDataMap.putAll(flowExecutorConfig.parentFlowExecutorConfig.currentCompositeFlowDataMap);
        }
        FlowExecutorRootConfig flowExecutorRootConfig = new FlowExecutorRootConfig();
        flowExecutorRootConfig.threadLocalDataMap.set(new HashMap());
        flowExecutorRootConfig.flowConfig = this.flowConfig;
        flowExecutorRootConfig.quickFlow = this.flowConfig.quickFlow;
        flowExecutorConfig.flowExecutorRootConfig = flowExecutorRootConfig;
        return new QuickFlowExecutor(flowExecutorConfig);
    }

    @Override
    public QuickFlowExecutor startFlow(BusinessFlow businessFlow) {
        return this.startFlow(businessFlow.name()).next(businessFlow);
    }

    @Override
    public QuickFlowExecutor startFlow(FlowExecutorOption flowExecutorOption) {
        if (null == this.flowConfig.flowConfigHandlerContext.flowMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        if (null == flowExecutorOption.name || flowExecutorOption.name.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0!");
        }
        CompositeBusinessFlow compositeBusinessFlow = this.flowConfig.flowConfigHandlerContext.flowMappingHandler.getCompositeBusinessFlow(flowExecutorOption.name);
        if (null != compositeBusinessFlow) {
            return this.startFlow(compositeBusinessFlow).putFlowContextData(flowExecutorOption.requestData, FlowContextDataRange.Flow, new FlowDataFeature[0]);
        }
        BusinessFlow businessFlow = this.flowConfig.flowConfigHandlerContext.flowMappingHandler.getFlow(flowExecutorOption.name);
        if (null != businessFlow) {
            return this.startFlow(businessFlow).putFlowContextData(flowExecutorOption.requestData, FlowContextDataRange.Flow, new FlowDataFeature[0]);
        }
        if (null == flowExecutorOption.flowArray || flowExecutorOption.flowArray.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u6d41\u7a0b\u5217\u8868!");
        }
        QuickFlowExecutor quickFlowExecutor = this.startFlow(flowExecutorOption.name).putFlowContextData(flowExecutorOption.requestData, FlowContextDataRange.Flow, new FlowDataFeature[0]);
        block16: for (int i = 0; i < flowExecutorOption.flowArray.size(); ++i) {
            JSONObject flow = flowExecutorOption.flowArray.getJSONObject(i);
            String type = flow.getString("\u7c7b\u578b");
            String name = flow.getString("\u540d\u79f0");
            switch (type) {
                case "\u666e\u901a\u6d41\u7a0b": {
                    if (name.startsWith("[\u590d\u5408\u6d41\u7a0b]")) {
                        String compositeBusinessName = name.substring("[\u590d\u5408\u6d41\u7a0b]".length());
                        CompositeBusinessFlow compositeBusinessFlow2 = this.flowConfig.flowConfigHandlerContext.flowMappingHandler.getCompositeBusinessFlow(compositeBusinessName);
                        if (null == compositeBusinessFlow2) {
                            throw new IllegalArgumentException("\u590d\u5408\u6d41\u7a0b\u4e0d\u5b58\u5728!\u6d41\u7a0b\u540d\u79f0:" + compositeBusinessName);
                        }
                        quickFlowExecutor.next(compositeBusinessFlow2);
                        continue block16;
                    }
                    BusinessFlow businessFlow2 = this.flowConfig.flowConfigHandlerContext.flowMappingHandler.getFlow(name);
                    if (null == businessFlow2) {
                        throw new IllegalArgumentException("\u6d41\u7a0b\u4e0d\u5b58\u5728!\u6d41\u7a0b\u540d\u79f0:" + name);
                    }
                    quickFlowExecutor.next(businessFlow2);
                    continue block16;
                }
                case "\u5904\u7406\u5668": {
                    String handleType;
                    switch (handleType = flow.getString("\u5904\u7406\u5668\u7c7b\u578b")) {
                        case "TryCatchFinally": {
                            TryCatchFinallyHandler tryCatchFinallyHandler = this.flowConfig.flowConfigHandlerContext.flowMappingHandler.getTryCatchFinallyHandler(name);
                            if (null == tryCatchFinallyHandler) {
                                throw new IllegalArgumentException("\u4e0d\u5b58\u5728TryCatchFinally\u5904\u7406\u5668!\u5904\u7406\u5668\u540d\u79f0:" + name);
                            }
                            quickFlowExecutor.tryCatchFinallyHandler(tryCatchFinallyHandler);
                            continue block16;
                        }
                        case "SingleFlow": {
                            SingleFlowListener singleFlowListener = this.flowConfig.flowConfigHandlerContext.flowMappingHandler.getSingleFlowListener(name);
                            if (null == singleFlowListener) {
                                throw new IllegalArgumentException("\u4e0d\u5b58\u5728singleFlow\u5904\u7406\u5668!\u5904\u7406\u5668\u540d\u79f0:" + name);
                            }
                            quickFlowExecutor.singleFlowListener(singleFlowListener);
                            continue block16;
                        }
                    }
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5904\u7406\u5668\u7c7b\u578b!\u7c7b\u578b" + handleType);
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d41\u7a0b\u7c7b\u578b!\u7c7b\u578b" + type);
                }
            }
        }
        return quickFlowExecutor;
    }

    @Override
    public QuickFlowExecutor startFlow(CompositeBusinessFlow compositeBusinessFlow) {
        QuickFlowExecutor quickFlowExecutor = this.startFlow(compositeBusinessFlow.name());
        compositeBusinessFlow.executeCompositeBusiness(quickFlowExecutor);
        FlowExecutorConfig flowExecutorConfig = quickFlowExecutor.getFlowExecutorConfig();
        QuickFlowConfigUtil.handleHasFlowConfig(compositeBusinessFlow, flowExecutorConfig);
        QuickFlowConfigUtil.handleLoadFlowConfig(compositeBusinessFlow, flowExecutorConfig);
        return quickFlowExecutor;
    }

    @Override
    public FlowContext executeFlow(BusinessFlow ... businessFlowList) {
        BusinessFlow firstBusinessFlow = businessFlowList[0];
        QuickFlowExecutor quickFlowExecutor = this.startFlow(firstBusinessFlow.name());
        for (BusinessFlow businessFlow : businessFlowList) {
            quickFlowExecutor.next(businessFlow);
        }
        return quickFlowExecutor.execute();
    }

    @Override
    public FlowContext executeFlow(CompositeBusinessFlow compositeBusinessFlow) {
        return this.startFlow(compositeBusinessFlow).execute();
    }

    @Override
    public FlowContext executeFlow(FlowExecutorOption flowExecutorOption) {
        return this.startFlow(flowExecutorOption).execute();
    }

    @Override
    public QuickFlow cloneFlow() {
        return QuickFlowBuilder.newInstance().putData(this.flowConfig.flowConfigDataContext.dataMap, FlowContextDataRange.Context).tryCatchFinallyHandler(this.flowConfig.flowConfigHandlerContext.tryCatchFinallyHandler).singleFlowListener(this.flowConfig.flowConfigHandlerContext.singleFlowListener);
    }
}

