/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.service.flowContext.data;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.dto.FlowContextDataRange;
import cn.schoolwow.quickflow.service.flowContext.data.FlowContextDataOperation;
import cn.schoolwow.quickflow.util.QuickFlowUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FlowContextDataOperationImpl
implements FlowContextDataOperation {
    private FlowExecutorConfig flowExecutorConfig;

    public FlowContextDataOperationImpl(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    @Override
    public FlowContext isDataNotExist(String key, String message) {
        if (!this.containKey(key)) {
            throw new IllegalArgumentException(message);
        }
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public boolean containKey(String key) {
        Object value = this.getData(key);
        return null != value;
    }

    @Override
    public Object checkData(String key) {
        Object value = this.getData(key);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public <T> T checkData(String key, Class<T> clazz) {
        T value = this.getData(key, clazz);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public <T> T checkData(String key, TypeReference<T> typeReference) {
        T value = this.getData(key, typeReference);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public <T> T checkInstanceData(Class<T> clazz) {
        String key = clazz.getName();
        T value = this.getData(key, clazz);
        this.checkValueEmpty(key, value);
        return value;
    }

    @Override
    public Object getData(String key) {
        Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
        if (null != threadLocalMap && threadLocalMap.containsKey(key)) {
            Object value = threadLocalMap.get(key);
            return value;
        }
        Map<String, Object> currentFlowDataMap = this.flowExecutorConfig.currentFlowDataMap;
        if (null != currentFlowDataMap && currentFlowDataMap.containsKey(key)) {
            return currentFlowDataMap.get(key);
        }
        Map<String, Object> currentCompositeFlowDataMap = this.flowExecutorConfig.currentCompositeFlowDataMap;
        if (null != currentCompositeFlowDataMap && currentCompositeFlowDataMap.containsKey(key)) {
            return currentCompositeFlowDataMap.get(key);
        }
        if (this.flowExecutorConfig.flowExecutorRootConfig.dataMap.containsKey(key)) {
            Object value = this.flowExecutorConfig.flowExecutorRootConfig.dataMap.get(key);
            if (this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet.contains(key)) {
                this.removeData(key);
                this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet.remove(key);
            }
            return value;
        }
        Map<String, Object> contextThreadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.threadLocalDataMap.get();
        if (null != contextThreadLocalMap && contextThreadLocalMap.containsKey(key)) {
            return contextThreadLocalMap.get(key);
        }
        if (this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.containsKey(key)) {
            return this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.get(key);
        }
        return null;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz) {
        Object value = this.getData(key);
        if (null == value) {
            return null;
        }
        if (value.getClass().getName().equalsIgnoreCase(clazz.getName())) {
            return (T)value;
        }
        if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            return (T)object.toJavaObject(clazz);
        }
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            return (T)array.toJavaObject(clazz);
        }
        try {
            T t = clazz.cast(value);
            return t;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("\u65e0\u6cd5\u8f6c\u6362\u7c7b\u578b!\u9884\u671f\u7c7b\u578b:" + clazz.getName() + ",\u5b9e\u9645\u7c7b\u578b:" + value.getClass().getName());
        }
    }

    @Override
    public <T> T getData(String key, TypeReference<T> typeReference) {
        Object value = this.getData(key);
        if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            return (T)object.toJavaObject(typeReference);
        }
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            return (T)array.toJavaObject(typeReference);
        }
        return (T)value;
    }

    @Override
    public Object getData(String key, Object defaultValue) {
        Object value = this.getData(key);
        if (null == value) {
            this.putTemporaryData(key, defaultValue);
            return defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz, T defaultValue) {
        T value = this.getData(key, clazz);
        if (null == value) {
            this.putTemporaryData(key, defaultValue);
            return defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getInstanceData(Class<T> clazz) {
        String key = clazz.getName();
        return this.getData(key, clazz);
    }

    @Override
    public Map<String, Object> getContextDataMap() {
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        FlowConfig flowConfig = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig;
        Map<String, Object> dataMap = flowConfig.flowConfigDataContext.dataMap;
        filterDataMap.putAll(dataMap);
        this.removeEntryByKeySet(filterDataMap, flowConfig.flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet);
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getFlowConfigDataMap() {
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        Map<String, Object> dataMap = this.flowExecutorConfig.flowExecutorRootConfig.dataMap;
        this.addEntryByKeySet(filterDataMap, dataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.flowConfigDataKeySet);
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getFlowExecuteDataMap() {
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        Map<String, Object> dataMap = this.flowExecutorConfig.flowExecutorRootConfig.dataMap;
        filterDataMap.putAll(dataMap);
        Map<String, Object> threadLocalDataMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
        if (null != threadLocalDataMap) {
            filterDataMap.putAll(threadLocalDataMap);
        }
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.dataMap.keySet());
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet);
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.requestDataKeySet);
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.temporaryDataKeySet);
        this.removeEntryByKeySet(filterDataMap, this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet);
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getRequestDataMap() {
        Map<String, Object> dataMap = this.flowExecutorConfig.flowExecutorRootConfig.dataMap;
        HashMap<String, Object> filterDataMap = new HashMap<String, Object>();
        for (String key : this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.requestDataKeySet) {
            if (!dataMap.containsKey(key)) continue;
            filterDataMap.put(key, dataMap.get(key));
        }
        return filterDataMap;
    }

    @Override
    public Map<String, Object> getThreadLocalDataMap() {
        Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
        return threadLocalMap;
    }

    @Override
    public Map<String, Object> getCurrentFlowData() {
        Map<String, Object> currentFlowData = this.flowExecutorConfig.currentFlowDataMap;
        return currentFlowData;
    }

    @Override
    public Map<String, Object> getCurrentCompositeFlowData() {
        return this.flowExecutorConfig.currentCompositeFlowDataMap;
    }

    @Override
    public FlowContext putFlowContextData(String key, Object value, FlowContextDataRange flowContextDataRange, FlowDataFeature ... flowDataFeatures) {
        if (null == flowContextDataRange) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == key || null == value) {
            return this.flowExecutorConfig.flowContext;
        }
        boolean skipExistData = FlowDataFeature.containFeature(FlowDataFeature.SkipExistData, flowDataFeatures);
        boolean temporaryData = FlowDataFeature.containFeature(FlowDataFeature.TemporaryData, flowDataFeatures);
        boolean requestData = FlowDataFeature.containFeature(FlowDataFeature.RequestData, flowDataFeatures);
        boolean returnData = FlowDataFeature.containFeature(FlowDataFeature.ReturnData, flowDataFeatures);
        boolean flowConfigData = FlowDataFeature.containFeature(FlowDataFeature.FlowConfigData, flowDataFeatures);
        switch (flowContextDataRange) {
            case Context: {
                FlowConfig flowConfig = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig;
                if (skipExistData) {
                    flowConfig.flowConfigDataContext.dataMap.putIfAbsent(key, value);
                } else {
                    flowConfig.flowConfigDataContext.dataMap.put(key, value);
                }
                if (!temporaryData) break;
                flowConfig.flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet.add(key);
                break;
            }
            case ContextThreadLocal: {
                FlowConfig flowConfig = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig;
                ThreadLocal<Map<String, Object>> threadLocal = flowConfig.flowConfigDataContext.threadLocalDataMap;
                if (null == threadLocal.get()) {
                    threadLocal.set(new HashMap());
                }
                Map<String, Object> contextThreadLocalMap = threadLocal.get();
                if (skipExistData) {
                    contextThreadLocalMap.putIfAbsent(key, value);
                } else {
                    contextThreadLocalMap.put(key, value);
                }
                if (!temporaryData) break;
                flowConfig.flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet.add(key);
                break;
            }
            case Flow: {
                if (skipExistData) {
                    this.flowExecutorConfig.flowExecutorRootConfig.dataMap.putIfAbsent(key, value);
                } else {
                    this.flowExecutorConfig.flowExecutorRootConfig.dataMap.put(key, value);
                }
                this.flowExecutorConfig.flowExecutorRootConfig.dataMap.put(key, value);
                if (requestData) {
                    this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.requestDataKeySet.add(key);
                }
                if (temporaryData) {
                    this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.temporaryDataKeySet.add(key);
                }
                if (returnData) {
                    this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet.add(key);
                }
                if (!flowConfigData) break;
                this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.flowConfigDataKeySet.add(key);
                break;
            }
            case CurrentCompositeBusiness: {
                Map<String, Object> currentCompositeFlowDataMap = this.flowExecutorConfig.currentCompositeFlowDataMap;
                if (skipExistData) {
                    currentCompositeFlowDataMap.putIfAbsent(key, value);
                } else {
                    currentCompositeFlowDataMap.put(key, value);
                }
                if (requestData) {
                    this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.requestDataKeySet.add(key);
                }
                if (temporaryData) {
                    this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.temporaryDataKeySet.add(key);
                }
                if (!returnData) break;
                this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.returnDataKeySet.add(key);
                break;
            }
            case CurrentFlow: {
                Map<String, Object> currentFlowDataMap = this.flowExecutorConfig.currentFlowDataMap;
                if (skipExistData) {
                    currentFlowDataMap.putIfAbsent(key, value);
                } else {
                    currentFlowDataMap.put(key, value);
                }
                currentFlowDataMap.put(key, value);
                break;
            }
            case ThreadLocal: {
                Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
                if (null == threadLocalMap) {
                    this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.set(new HashMap());
                }
                threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
                threadLocalMap.put(key, value);
            }
        }
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public FlowContext putFlowContextData(Map<String, Object> dataMap, FlowContextDataRange flowContextDataRange, FlowDataFeature ... flowDataFeatures) {
        Set<String> keySet = dataMap.keySet();
        for (String key : keySet) {
            Object value = dataMap.get(key);
            this.putFlowContextData(key, value, flowContextDataRange, flowDataFeatures);
        }
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public FlowContext putContextData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.Context, flowDataFeatures);
    }

    @Override
    public FlowContext putContextThreadLocalData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.ContextThreadLocal, flowDataFeatures);
    }

    @Override
    public FlowContext putData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.Flow, flowDataFeatures);
    }

    @Override
    public FlowContext putTemporaryData(String key, Object value) {
        return this.putFlowContextData(key, value, FlowContextDataRange.Flow, FlowDataFeature.TemporaryData);
    }

    @Override
    public FlowContext putReturnData(String key, Object value) {
        return this.putFlowContextData(key, value, FlowContextDataRange.Flow, FlowDataFeature.ReturnData);
    }

    @Override
    public FlowContext putCurrentCompositeFlowData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.CurrentCompositeBusiness, flowDataFeatures);
    }

    @Override
    public FlowContext putCurrentFlowData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.CurrentFlow, flowDataFeatures);
    }

    @Override
    public FlowContext putThreadLocalData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.ThreadLocal, flowDataFeatures);
    }

    @Override
    public FlowContext putInstanceData(Object instance) {
        return this.putInstanceData(instance, FlowContextDataRange.Flow, new FlowDataFeature[0]);
    }

    @Override
    public FlowContext putInstanceData(Object instance, Class classType) {
        if (null == instance) {
            return this.flowExecutorConfig.flowContext;
        }
        String key = classType.getName();
        return this.putFlowContextData(key, instance, FlowContextDataRange.Flow, new FlowDataFeature[0]);
    }

    @Override
    public FlowContext putInstanceData(Object instance, Class classType, FlowContextDataRange flowContextDataRange, FlowDataFeature ... flowDataFeatures) {
        if (null == instance) {
            return this.flowExecutorConfig.flowContext;
        }
        String key = classType.getName();
        return this.putFlowContextData(key, instance, flowContextDataRange, flowDataFeatures);
    }

    @Override
    public FlowContext putInstanceData(Object instance, FlowContextDataRange flowContextDataRange, FlowDataFeature ... flowDataFeatures) {
        if (null == instance) {
            return this.flowExecutorConfig.flowContext;
        }
        String key = QuickFlowUtil.getInstanceClassName(instance);
        return this.putFlowContextData(key, instance, flowContextDataRange, flowDataFeatures);
    }

    @Override
    public FlowContext removeData(String key) {
        this.flowExecutorConfig.flowExecutorRootConfig.dataMap.remove(key);
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public FlowContext removeData(String key, FlowContextDataRange flowContextDataRange) {
        if (null == flowContextDataRange) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (flowContextDataRange) {
            case Context: {
                FlowConfig flowConfig = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig;
                flowConfig.flowConfigDataContext.dataMap.remove(key);
                break;
            }
            case ContextThreadLocal: {
                FlowConfig flowConfig = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig;
                ThreadLocal<Map<String, Object>> threadLocal = flowConfig.flowConfigDataContext.threadLocalDataMap;
                if (null == threadLocal.get()) {
                    threadLocal.set(new HashMap());
                }
                Map<String, Object> contextThreadLocalMap = threadLocal.get();
                contextThreadLocalMap.remove(key);
                break;
            }
            case Flow: {
                this.flowExecutorConfig.flowExecutorRootConfig.dataMap.remove(key);
                break;
            }
            case CurrentCompositeBusiness: {
                Map<String, Object> currentCompositeFlowDataMap = this.flowExecutorConfig.currentCompositeFlowDataMap;
                currentCompositeFlowDataMap.remove(key);
                break;
            }
            case CurrentFlow: {
                Map<String, Object> currentFlowDataMap = this.flowExecutorConfig.currentFlowDataMap;
                currentFlowDataMap.remove(key);
                break;
            }
            case ThreadLocal: {
                Map<String, Object> threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
                if (null == threadLocalMap) {
                    this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.set(new HashMap());
                }
                threadLocalMap = this.flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
                threadLocalMap.remove(key);
            }
        }
        return this.flowExecutorConfig.flowContext;
    }

    @Override
    public FlowContext joinQuickFlow(QuickFlow quickFlow) {
        Map<String, Object> contextDataMap = quickFlow.getContextDataMap(FlowContextDataRange.Context);
        for (String key : contextDataMap.keySet()) {
            this.putData(key, contextDataMap.get(key), new FlowDataFeature[0]);
        }
        Set<String> temporaryDataKeySet = quickFlow.getFlowConfig().flowConfigDataContext.flowContextDataKeySet.temporaryDataKeySet;
        this.flowExecutorConfig.flowExecutorRootConfig.flowContextDataKeySet.temporaryDataKeySet.addAll(temporaryDataKeySet);
        return this.flowExecutorConfig.flowContext;
    }

    private void checkValueEmpty(String key, Object value) {
        if (null == value) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void addEntryByKeySet(Map<String, Object> filterDataMap, Map<String, Object> dataMap, Set<String> keySet) {
        for (String key : keySet) {
            filterDataMap.put(key, dataMap.get(key));
        }
    }

    private void removeEntryByKeySet(Map<String, Object> dataMap, Set<String> keySet) {
        for (String key : keySet) {
            dataMap.remove(key);
        }
    }
}

