/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.service.flowContext;

import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.service.flowContext.data.FlowContextDataOperation;
import cn.schoolwow.quickflow.service.flowContext.data.FlowContextDataOperationImpl;
import cn.schoolwow.quickflow.service.flowContext.execute.FlowContextExecuteOperation;
import cn.schoolwow.quickflow.service.flowContext.execute.FlowContextExecuteOperationImpl;
import cn.schoolwow.quickflow.service.flowContext.option.FlowContextOption;
import cn.schoolwow.quickflow.service.flowContext.option.FlowContextOptionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FlowContextInvocationHandler
implements InvocationHandler {
    private FlowContextOption flowContextOption;
    private FlowContextDataOperation flowContextDataOperation;
    private FlowContextExecuteOperation flowContextExecuteOperation;
    private Object[] interfaceInstanceArray;

    public FlowContextInvocationHandler(FlowExecutorConfig flowExecutorConfig) {
        this.flowContextOption = new FlowContextOptionImpl(flowExecutorConfig);
        this.flowContextDataOperation = new FlowContextDataOperationImpl(flowExecutorConfig);
        this.flowContextExecuteOperation = new FlowContextExecuteOperationImpl(flowExecutorConfig);
        this.interfaceInstanceArray = new Object[]{this.flowContextOption, this.flowContextDataOperation, this.flowContextExecuteOperation};
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        for (Object interfaceInstance : this.interfaceInstanceArray) {
            Class<?> interfaceClass = interfaceInstance.getClass().getInterfaces()[0];
            if (!interfaceClass.getSimpleName().equalsIgnoreCase(interfaceName)) continue;
            try {
                return method.invoke(interfaceInstance, args);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw targetException;
            }
        }
        throw new IllegalAccessError("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5!\u65b9\u6cd5\u540d:" + method.getName());
    }
}

