/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.executor;

import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.domain.FlowExecutorRootConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentCompositeBusinessException;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.exception.QuickFlowRuntimeException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import cn.schoolwow.quickflow.util.QuickFlowConfigUtil;
import cn.schoolwow.quickflow.util.QuickFlowUtil;
import com.alibaba.fastjson.JSONArray;
import java.util.Collection;

public class QuickFlowExecutorInner {
    private FlowExecutorConfig flowExecutorConfig;
    private FlowExecutorRootConfig flowExecutorRootConfig;
    private FlowConfig flowConfig;

    public QuickFlowExecutorInner(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
        this.flowExecutorRootConfig = flowExecutorConfig.flowExecutorRootConfig;
        this.flowConfig = this.flowExecutorRootConfig.flowConfig;
    }

    public FlowContext doExecute() {
        if (this.flowExecutorConfig.flowExecutorRootConfig.flowArray.isEmpty()) {
            JSONArray flowArray = QuickFlowUtil.getFlowArray(this.flowExecutorConfig);
            this.flowExecutorConfig.flowExecutorRootConfig.flowArray.addAll((Collection)flowArray);
        }
        try {
            this.beforeExecuteBusiness();
            this.executeBusiness();
        }
        catch (Exception e) {
            this.handleBusinessException(e);
        }
        finally {
            this.handleBusinessFinally();
        }
        return this.flowExecutorConfig.flowContext;
    }

    private void beforeExecuteBusiness() {
        this.executeTryCatchFinallyHandler(true, this.flowExecutorConfig.tryCatchFinallyHandler, "tryStart", null);
        boolean shouldExecuteGlobalTryCatchFinally = this.getGlobalHandlerShouldExecute("TryCatchFinally");
        this.flowExecutorConfig.recordContent((shouldExecuteGlobalTryCatchFinally ? "\u6267\u884c" : "\u4e0d\u6267\u884c") + "\u5168\u5c40tryCatchFinally\u5904\u7406\u5668-tryStart");
        this.executeTryCatchFinallyHandler(shouldExecuteGlobalTryCatchFinally, this.flowConfig.flowConfigHandlerContext.tryCatchFinallyHandler, "tryStart", null);
        boolean shouldExecuteGlobalBeforeAfter = this.getGlobalHandlerShouldExecute("BeforeAfter");
        this.flowExecutorConfig.recordContent((shouldExecuteGlobalBeforeAfter ? "\u6267\u884c" : "\u4e0d\u6267\u884c") + "\u5168\u5c40beforeAfter\u5904\u7406\u5668");
        if (!this.flowExecutorConfig.compositeBusiness && null == this.flowExecutorConfig.parentFlowExecutorConfig) {
            this.flowExecutorConfig.recordContent("\u5f53\u524d\u6d41\u7a0b\u662f\u4e3b\u6d41\u7a0b!\u6d41\u7a0bid:" + this.flowExecutorRootConfig.id);
        }
        this.flowExecutorConfig.flowExecutorRootConfig.incrementFlowLevel();
        if (this.flowExecutorConfig.flowList.size() > 1 || this.flowExecutorConfig.flowList.size() == 1 && this.flowExecutorConfig.flowList.get(0).name().startsWith("[\u590d\u5408\u6d41\u7a0b]")) {
            this.flowExecutorConfig.printFlowTrace("[" + this.flowExecutorConfig.name + "]");
        }
    }

    private void executeBusiness() throws Exception {
        for (BusinessFlow flow : this.flowExecutorConfig.flowList) {
            long endTime;
            boolean shouldExecuteGlobalSingleFlow;
            if (null == flow.name()) {
                throw new IllegalArgumentException("\u6d41\u7a0b\u540d\u4e0d\u80fd\u4e3a\u7a7a!\u6d89\u53ca\u7c7b:" + flow.getClass().getName());
            }
            this.flowExecutorConfig.getRemarkBuilder().setLength(0);
            this.flowExecutorConfig.currentFlow = flow;
            QuickFlowConfigUtil.handleHasFlowConfig(flow, this.flowExecutorConfig);
            QuickFlowConfigUtil.handleLoadFlowConfig(flow, this.flowExecutorConfig);
            long startTime = System.currentTimeMillis();
            try {
                this.executeSingleFlowHandler(true, flow, this.flowExecutorConfig.singleFlowListener, "before");
                shouldExecuteGlobalSingleFlow = this.getGlobalHandlerShouldExecute("SingleFlow");
                this.flowExecutorConfig.recordContent((shouldExecuteGlobalSingleFlow ? "\u6267\u884c" : "\u4e0d\u6267\u884c") + "\u5168\u5c40singleFlow-before\u5904\u7406\u5668");
                this.executeSingleFlowHandler(shouldExecuteGlobalSingleFlow, flow, this.flowConfig.flowConfigHandlerContext.singleFlowListener, "before");
                startTime = System.currentTimeMillis();
                flow.executeBusinessFlow(this.flowExecutorConfig.flowContext);
                long endTime2 = System.currentTimeMillis();
                if (!flow.name().startsWith("[\u590d\u5408\u6d41\u7a0b]")) {
                    this.flowExecutorConfig.recordContent("\u5f53\u524d\u6d41\u7a0b\u4e0d\u662f\u590d\u5408\u6d41\u7a0b");
                    this.flowExecutorConfig.printFlowTraceWithIndex("|" + (endTime2 - startTime) + "\u6beb\u79d2|" + flow.name() + this.flowExecutorConfig.getRemarkBuilder().toString());
                } else {
                    this.flowExecutorConfig.recordContent("\u5f53\u524d\u6d41\u7a0b\u662f\u590d\u5408\u6d41\u7a0b");
                }
            }
            catch (BrokenCurrentFlowException e) {
                endTime = System.currentTimeMillis();
                this.flowExecutorConfig.printFlowTraceWithIndex("|" + (endTime - startTime) + "\u6beb\u79d2|[x]|" + flow.name() + "|\u5f53\u524d\u6d41\u7a0b\u4e2d\u65ad|\u4e2d\u65ad\u539f\u56e0:" + e.getReason() + this.flowExecutorConfig.getRemarkBuilder().toString());
            }
            catch (BrokenCurrentCompositeBusinessException e) {
                endTime = System.currentTimeMillis();
                this.flowExecutorConfig.printFlowTraceWithIndex("|" + (endTime - startTime) + "\u6beb\u79d2|[x]|" + flow.name() + "|\u5f53\u524d\u590d\u5408\u6d41\u7a0b\u4e2d\u65ad|\u4e2d\u65ad\u539f\u56e0:" + e.getReason() + this.flowExecutorConfig.getRemarkBuilder().toString());
                this.flowExecutorConfig.flowExecutorRootConfig.decrementFlowLevel();
                break;
            }
            this.executeSingleFlowHandler(true, flow, this.flowExecutorConfig.singleFlowListener, "after");
            shouldExecuteGlobalSingleFlow = this.getGlobalHandlerShouldExecute("SingleFlow");
            this.flowExecutorConfig.recordContent((shouldExecuteGlobalSingleFlow ? "\u6267\u884c" : "\u4e0d\u6267\u884c") + "\u5168\u5c40singleFlow-after\u5904\u7406\u5668");
            this.executeSingleFlowHandler(shouldExecuteGlobalSingleFlow, flow, this.flowConfig.flowConfigHandlerContext.singleFlowListener, "after");
            this.flowExecutorConfig.currentFlowDataMap.clear();
        }
        this.executeTryCatchFinallyHandler(true, this.flowExecutorConfig.tryCatchFinallyHandler, "tryEnd", null);
        boolean shouldExecuteGlobalTryCatchFinally = this.getGlobalHandlerShouldExecute("TryCatchFinally");
        this.flowExecutorConfig.recordContent((shouldExecuteGlobalTryCatchFinally ? "\u6267\u884c" : "\u4e0d\u6267\u884c") + "\u5168\u5c40tryCatchFinally\u5904\u7406\u5668-tryEnd");
        this.executeTryCatchFinallyHandler(shouldExecuteGlobalTryCatchFinally, this.flowConfig.flowConfigHandlerContext.tryCatchFinallyHandler, "tryEnd", null);
        this.flowExecutorConfig.currentCompositeFlowDataMap.clear();
    }

    private void handleBusinessException(Exception e) {
        this.flowExecutorConfig.flowExecutorRootConfig.decrementFlowLevel();
        Exception targetException = e;
        QuickFlowRuntimeException quickFlowRuntimeException = null;
        if (e instanceof QuickFlowRuntimeException) {
            targetException = ((QuickFlowRuntimeException)e).targetException;
            quickFlowRuntimeException = (QuickFlowRuntimeException)e;
        } else {
            quickFlowRuntimeException = new QuickFlowRuntimeException(e);
        }
        if (targetException instanceof BrokenException) {
            this.handleBrokenException((BrokenException)targetException);
        } else {
            this.handleException(e, quickFlowRuntimeException);
        }
    }

    private void handleBrokenException(BrokenException e) {
        boolean shouldIgnoreBroken = this.getShouldIgnoreBroken();
        this.flowExecutorConfig.recordContent((shouldIgnoreBroken ? "\u5ffd\u7565" : "\u4e0d\u5ffd\u7565") + "\u4e2d\u65ad\u5f02\u5e38");
        if (null != this.flowExecutorConfig.parentFlowExecutorConfig) {
            this.flowExecutorConfig.printFlowTraceWithIndex("|[x]|" + (null != this.flowExecutorConfig.currentFlow ? this.flowExecutorConfig.currentFlow.name() : "\u4e8b\u4ef6\u6267\u884c\u4e2d\u65ad\u65b9\u6cd5") + "|\u4e1a\u52a1\u6d41\u7a0b\u53d1\u751f\u4e2d\u65ad|\u539f\u56e0:" + e.getReason() + (shouldIgnoreBroken ? "|\u5ffd\u7565\u8be5\u4e2d\u65ad" : "") + this.flowExecutorConfig.getRemarkBuilder().toString());
        } else {
            this.flowExecutorConfig.flowExecutorRootConfig.brokenReason = e.getReason();
            this.flowExecutorConfig.printFlowTraceWithIndex("|[x]|" + (null != this.flowExecutorConfig.currentFlow ? this.flowExecutorConfig.currentFlow.name() : "\u4e8b\u4ef6\u6267\u884c\u4e2d\u65ad\u65b9\u6cd5") + "|\u4e1a\u52a1\u6d41\u7a0b\u7ec8\u6b62|\u539f\u56e0:" + e.getReason() + this.flowExecutorConfig.getRemarkBuilder().toString());
        }
        if (!shouldIgnoreBroken) {
            throw e;
        }
    }

    private void handleException(Exception targetException, QuickFlowRuntimeException quickFlowRuntimeException) {
        boolean shouldIgnoreException = this.getShouldIgnoreException();
        this.flowExecutorConfig.recordContent((shouldIgnoreException ? "\u5ffd\u7565" : "\u4e0d\u5ffd\u7565") + "\u629b\u51fa\u5f02\u5e38");
        String exceptionMessage = targetException.getClass().getName() + "-" + targetException.getMessage();
        if (null != this.flowExecutorConfig.parentFlowExecutorConfig) {
            this.flowExecutorConfig.printFlowTraceWithIndex("|[x]|" + (null != this.flowExecutorConfig.currentFlow ? this.flowExecutorConfig.currentFlow.name() : "\u4e8b\u4ef6\u629b\u51fa\u5f02\u5e38") + (shouldIgnoreException ? "|\u5ffd\u7565\u8be5\u5f02\u5e38" : "") + "|\u5f02\u5e38\u4fe1\u606f:" + exceptionMessage);
            this.executeTryCatchFinallyHandler(true, this.flowExecutorConfig.tryCatchFinallyHandler, "catch", targetException);
        } else {
            this.flowExecutorConfig.printFlowTraceWithIndex("|[x]|" + (null != this.flowExecutorConfig.currentFlow ? this.flowExecutorConfig.currentFlow.name() : "\u4e8b\u4ef6\u629b\u51fa\u5f02\u5e38") + (shouldIgnoreException ? "|\u5ffd\u7565\u8be5\u5f02\u5e38" : "") + "|\u5f02\u5e38\u4fe1\u606f:" + exceptionMessage);
            this.executeTryCatchFinallyHandler(true, this.flowExecutorConfig.tryCatchFinallyHandler, "catch", targetException);
            this.flowExecutorConfig.flowExecutorRootConfig.exception = targetException;
            boolean shouldExecuteGlobalTryCatchFinally = this.getGlobalHandlerShouldExecute("TryCatchFinally");
            this.flowExecutorConfig.recordContent((shouldExecuteGlobalTryCatchFinally ? "\u6267\u884c" : "\u4e0d\u6267\u884c") + "\u5168\u5c40tryCatchFinally\u5904\u7406\u5668-catch");
            this.executeTryCatchFinallyHandler(shouldExecuteGlobalTryCatchFinally, this.flowConfig.flowConfigHandlerContext.tryCatchFinallyHandler, "catch", targetException);
        }
        if (!shouldIgnoreException) {
            if (targetException instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)targetException;
                throw runtimeException;
            }
            throw quickFlowRuntimeException;
        }
    }

    private void handleBusinessFinally() {
        this.executeTryCatchFinallyHandler(true, this.flowExecutorConfig.tryCatchFinallyHandler, "finally", null);
        boolean shouldExecuteGlobalTryCatchFinally = this.getGlobalHandlerShouldExecute("TryCatchFinally");
        this.flowExecutorConfig.recordContent((shouldExecuteGlobalTryCatchFinally ? "\u6267\u884c" : "\u4e0d\u6267\u884c") + "\u5168\u5c40tryCatchFinally\u5904\u7406\u5668-finally");
        this.executeTryCatchFinallyHandler(shouldExecuteGlobalTryCatchFinally, this.flowConfig.flowConfigHandlerContext.tryCatchFinallyHandler, "finally", null);
        if (this.flowExecutorConfig.flowList.size() > 1 || this.flowExecutorConfig.flowList.size() == 1 && this.flowExecutorConfig.flowList.get(0).name().startsWith("[\u590d\u5408\u6d41\u7a0b]")) {
            this.flowExecutorConfig.printFlowTrace("[" + this.flowExecutorConfig.name + "]");
        }
        this.flowExecutorConfig.recordContent("================");
        if (null == this.flowExecutorConfig.flowExecutorRootConfig.exception && null == this.flowExecutorConfig.flowExecutorRootConfig.brokenReason) {
            this.flowExecutorConfig.flowExecutorRootConfig.decrementFlowLevel();
        }
    }

    private void executeTryCatchFinallyHandler(boolean shouldExecute, TryCatchFinallyHandler tryCatchFinallyHandler, String operation, Exception e) {
        if (null == tryCatchFinallyHandler || !shouldExecute) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            switch (operation) {
                case "tryStart": {
                    tryCatchFinallyHandler.handleTryStart(this.flowExecutorConfig.flowContext);
                    break;
                }
                case "tryEnd": {
                    tryCatchFinallyHandler.handleTryEnd(this.flowExecutorConfig.flowContext);
                    break;
                }
                case "catch": {
                    tryCatchFinallyHandler.handleException(this.flowExecutorConfig.flowContext, e);
                    break;
                }
                case "finally": {
                    if (this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigHandlerContext.tryCatchFinallyHandler == tryCatchFinallyHandler) {
                        this.flowExecutorConfig.flowExecutorRootConfig.decrementFlowLevel();
                        this.flowExecutorConfig.printFlowTraceWithIndex(operation + ":" + tryCatchFinallyHandler.name());
                    }
                    tryCatchFinallyHandler.handleFinally(this.flowExecutorConfig.flowContext);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5!\u65b9\u6cd5\u540d:" + operation);
                }
            }
            long endTime = System.currentTimeMillis();
            this.flowExecutorConfig.printFlowTraceWithIndex("|" + (endTime - startTime) + "\u6beb\u79d2|" + operation + ":" + tryCatchFinallyHandler.name());
        }
        catch (Exception ex) {
            if (ex instanceof QuickFlowRuntimeException) {
                throw (QuickFlowRuntimeException)ex;
            }
            throw new QuickFlowRuntimeException(ex);
        }
    }

    private void executeSingleFlowHandler(boolean shouldExecute, BusinessFlow flow, SingleFlowListener singleFlowListener, String operation) throws Exception {
        if (null == singleFlowListener || !shouldExecute) {
            return;
        }
        switch (operation) {
            case "before": {
                singleFlowListener.beforeExecuteFlow(flow, this.flowExecutorConfig.flowContext);
                break;
            }
            case "after": {
                singleFlowListener.afterExecuteFlow(flow, this.flowExecutorConfig.flowContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5!\u65b9\u6cd5\u540d:" + operation);
            }
        }
    }

    private boolean getShouldIgnoreBroken() {
        if (null != this.flowExecutorConfig.ignoreBroken) {
            return this.flowExecutorConfig.ignoreBroken;
        }
        return this.flowConfig.flowConfigSwitcherContext.ignoreBroken;
    }

    private boolean getShouldIgnoreException() {
        if (null != this.flowExecutorConfig.ignoreException) {
            return this.flowExecutorConfig.ignoreException;
        }
        return this.flowConfig.flowConfigSwitcherContext.ignoreException;
    }

    private boolean getGlobalHandlerShouldExecute(String type) {
        if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
            return true;
        }
        if (this.flowExecutorConfig.compositeBusiness) {
            return false;
        }
        return false;
    }
}

