/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.domain.FlowExecutorRootConfig;
import cn.schoolwow.quickflow.dto.FlowContextDataRange;
import cn.schoolwow.quickflow.executor.QuickFlowExecutorInner;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import cn.schoolwow.quickflow.util.QuickFlowUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class QuickFlowExecutor {
    private FlowExecutorConfig flowExecutorConfig;

    public QuickFlowExecutor(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    public QuickFlowExecutor startRecord(boolean startRecord) {
        this.flowExecutorConfig.flowExecutorRootConfig.startRecord = startRecord;
        return this;
    }

    public QuickFlowExecutor putFlowContextData(String key, Object value, FlowContextDataRange flowContextDataRange, FlowDataFeature ... flowDataFeatures) {
        switch (flowContextDataRange) {
            case CurrentCompositeBusiness: {
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
                    this.putData(key, value, flowDataFeatures);
                    break;
                }
                this.flowExecutorConfig.flowContext.putCurrentCompositeFlowData(key, value, flowDataFeatures);
                break;
            }
            default: {
                this.flowExecutorConfig.flowContext.putFlowContextData(key, value, flowContextDataRange, flowDataFeatures);
            }
        }
        return this;
    }

    public QuickFlowExecutor putDataMap(Map<String, Object> dataMap, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(dataMap, FlowContextDataRange.Flow, flowDataFeatures);
    }

    public QuickFlowExecutor putFlowContextData(Map<String, Object> dataMap, FlowContextDataRange flowContextDataRange, FlowDataFeature ... flowDataFeatures) {
        Set<String> keySet = dataMap.keySet();
        for (String key : keySet) {
            Object value = dataMap.get(key);
            this.putFlowContextData(key, value, flowContextDataRange, flowDataFeatures);
        }
        return this;
    }

    public QuickFlowExecutor putContextData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.Context, flowDataFeatures);
    }

    public QuickFlowExecutor putContextThreadLocalData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.ContextThreadLocal, flowDataFeatures);
    }

    public QuickFlowExecutor putData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        flowDataFeatures = this.addFlowDataFeature(FlowDataFeature.RequestData, flowDataFeatures);
        return this.putFlowContextData(key, value, FlowContextDataRange.Flow, flowDataFeatures);
    }

    public QuickFlowExecutor putTemporaryData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putTemporaryData(key, value);
        return this;
    }

    public QuickFlowExecutor putReturnData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        flowDataFeatures = this.addFlowDataFeature(FlowDataFeature.ReturnData, flowDataFeatures);
        return this.putFlowContextData(key, value, FlowContextDataRange.Flow, flowDataFeatures);
    }

    public QuickFlowExecutor putCurrentCompositeFlowData(String key, Object value, FlowDataFeature ... flowDataFeatures) {
        return this.putFlowContextData(key, value, FlowContextDataRange.CurrentCompositeBusiness, flowDataFeatures);
    }

    public QuickFlowExecutor putCurrentCompositeInstanceData(Object instance) {
        if (null == instance) {
            return this;
        }
        String key = QuickFlowUtil.getInstanceClassName(instance);
        this.putCurrentCompositeFlowData(key, instance, new FlowDataFeature[0]);
        return this;
    }

    public QuickFlowExecutor putInstanceData(Object instance) {
        return this.putInstanceData(instance, FlowContextDataRange.CurrentCompositeBusiness, new FlowDataFeature[0]);
    }

    public QuickFlowExecutor putInstanceData(Object instance, Class classType) {
        if (null == instance) {
            return this;
        }
        String key = classType.getName();
        this.putFlowContextData(key, instance, FlowContextDataRange.CurrentCompositeBusiness, new FlowDataFeature[0]);
        return this;
    }

    public QuickFlowExecutor putInstanceData(Object instance, FlowContextDataRange flowContextDataRange, FlowDataFeature ... flowDataFeatures) {
        if (null == instance) {
            return this;
        }
        String key = QuickFlowUtil.getInstanceClassName(instance);
        this.putFlowContextData(key, instance, flowContextDataRange, flowDataFeatures);
        return this;
    }

    public QuickFlowExecutor putThreadLocalData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putThreadLocalData(key, value, new FlowDataFeature[0]);
        return this;
    }

    public QuickFlowExecutor next(String flowName) {
        if (null == this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigHandlerContext.flowMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        BusinessFlow flow = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigHandlerContext.flowMappingHandler.getFlow(flowName);
        if (null == flow) {
            CompositeBusinessFlow compositeBusinessFlow = this.flowExecutorConfig.flowExecutorRootConfig.flowConfig.flowConfigHandlerContext.flowMappingHandler.getCompositeBusinessFlow(flowName);
            if (null == compositeBusinessFlow) {
                throw new IllegalArgumentException("\u6839\u636e\u6d41\u7a0b\u540d\u79f0\u67e5\u627e\u6d41\u7a0b\u793a\u4f8b\u5931\u8d25!\u6d41\u7a0b\u540d\u79f0:" + flowName);
            }
            this.next(compositeBusinessFlow);
        } else {
            this.flowExecutorConfig.flowList.add(flow);
        }
        return this;
    }

    public QuickFlowExecutor next(BusinessFlow flow) {
        this.flowExecutorConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor next(CompositeBusinessFlow compositeBusinessFlow) {
        BusinessFlow businessFlow = QuickFlowUtil.getBusinessFlow(compositeBusinessFlow);
        this.flowExecutorConfig.flowList.add(businessFlow);
        return this;
    }

    public QuickFlowExecutor printTrace(boolean printTrace) {
        this.flowExecutorConfig.printTrace = printTrace;
        return this;
    }

    public QuickFlowExecutor ignoreBroken(boolean ignoreBroken) {
        this.flowExecutorConfig.ignoreBroken = ignoreBroken;
        return this;
    }

    public QuickFlowExecutor ignoreException(boolean ignoreException) {
        this.flowExecutorConfig.ignoreException = ignoreException;
        return this;
    }

    public QuickFlowExecutor singleFlowListener(SingleFlowListener singleFlowListener) {
        this.flowExecutorConfig.singleFlowListener = singleFlowListener;
        return this;
    }

    public QuickFlowExecutor tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        this.flowExecutorConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    public FlowExecutorOption generateFlowExecuteOption() {
        FlowExecutorOption flowExecutorOption = new FlowExecutorOption();
        flowExecutorOption.name = this.flowExecutorConfig.name;
        flowExecutorOption.requestData = new JSONObject(this.flowExecutorConfig.flowContext.getRequestDataMap());
        flowExecutorOption.flowArray = QuickFlowUtil.getFlowArray(this.flowExecutorConfig);
        return flowExecutorOption;
    }

    public FlowContext execute() {
        QuickFlowExecutorInner quickFlowExecutorInner = new QuickFlowExecutorInner(this.flowExecutorConfig);
        return quickFlowExecutorInner.doExecute();
    }

    public FlowContext getFlowContext() {
        return this.flowExecutorConfig.flowContext;
    }

    public FlowExecutorConfig getFlowExecutorConfig() {
        return this.flowExecutorConfig;
    }

    public FlowExecutorRootConfig getFlowExecutorRootConfig() {
        return this.flowExecutorConfig.flowExecutorRootConfig;
    }

    private FlowDataFeature[] addFlowDataFeature(FlowDataFeature addFlowDataFeature, FlowDataFeature[] flowDataFeatures) {
        ArrayList<FlowDataFeature> flowDataFeatureList = new ArrayList<FlowDataFeature>();
        for (FlowDataFeature flowDataFeature : flowDataFeatures) {
            flowDataFeatureList.add(flowDataFeature);
        }
        if (!flowDataFeatureList.contains((Object)addFlowDataFeature)) {
            flowDataFeatureList.add(addFlowDataFeature);
        }
        flowDataFeatures = flowDataFeatureList.toArray(new FlowDataFeature[0]);
        return flowDataFeatures;
    }
}

