/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.service.quickFlow.QuickFlowInvocationHandler;
import com.alibaba.fastjson.parser.ParserConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class QuickFlowBuilder {
    private static QuickFlow defaultQuickFlow;

    public static QuickFlow newInstance() {
        QuickFlow quickFlowProxy;
        FlowConfig flowConfig = new FlowConfig();
        QuickFlowInvocationHandler quickFlowInvocationHandler = new QuickFlowInvocationHandler(flowConfig);
        flowConfig.quickFlow = quickFlowProxy = (QuickFlow)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{QuickFlow.class}, (InvocationHandler)quickFlowInvocationHandler);
        return quickFlowProxy;
    }

    public static QuickFlow quickFlow() {
        return defaultQuickFlow;
    }

    public static QuickFlow executeStaticFlowList(BusinessFlow ... businessFlows) {
        defaultQuickFlow.executeFlow(businessFlows);
        return defaultQuickFlow;
    }

    public static QuickFlowExecutor startFlow(BusinessFlow businessFlow) {
        return defaultQuickFlow.startFlow(businessFlow);
    }

    public static QuickFlowExecutor startFlow(CompositeBusinessFlow compositeBusinessFlow) {
        return defaultQuickFlow.startFlow(compositeBusinessFlow);
    }

    public static FlowContext executeFlow(BusinessFlow businessFlow) {
        return defaultQuickFlow.executeFlow(businessFlow);
    }

    public static FlowContext executeFlow(CompositeBusinessFlow compositeBusinessFlow) {
        return defaultQuickFlow.executeFlow(compositeBusinessFlow);
    }

    static {
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        defaultQuickFlow = QuickFlowBuilder.newInstance();
    }
}

