package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FlowExecutorConfig {
    /**
     * 流程名称
     */
    public String name;

    /**
     * 流程上下文对象
     */
    public FlowContext flowContext;

    /**
     * 是否打印流程列表
     */
    public Boolean printTrace;

    /**
     * 是否忽略中断
     */
    public Boolean ignoreBroken;

    /**
     * 是否忽略异常
     */
    public Boolean ignoreException;

    /**
     * 是否所有流程都执行全局tryCatchFinally处理器
     */
    public Boolean executeGlobalTryCatchFinally;

    /**
     * 是否所有流程都执行全局beforeAfter处理器
     */
    public Boolean executeGlobalBeforeAfter;

    /**
     * 是否所有流程都执行全局singleFlow处理器
     */
    public Boolean executeGlobalSingleFlow;

    /**
     * 当前流程
     * */
    public BusinessFlow currentFlow;

    /**
     * 业务流程列表
     */
    public List<BusinessFlow> flowList = new ArrayList<>();

    /**
     * 流程名称列表
     */
    public List<String> flowNameList = new ArrayList<>();

    /**
     * 临时数据key
     */
    public Set<String> temporaryDataKeySet = new HashSet<>();

    /**
     * 流程执行前后处理事件监听
     */
    public SingleFlowListener singleFlowListener;

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * 流程列表前后添加流程列表
     */
    public BeforeAfterFlowHandler beforeAfterFlowHandler;

    /**
     * 上级流程配置
     */
    public FlowExecutorConfig parentFlowExecutorConfig;

    /**
     * 主流程配置
     */
    public FlowExecutorRootConfig flowExecutorRootConfig;

    /**
     * 是否为复合流程
     * */
    public boolean compositeBusiness;

    /**
     * 打印流程内容
     */
    public void printFlowTrace(String content) {
        Boolean shouldPrintTrace = this.printTrace;
        if(null==shouldPrintTrace){
            FlowExecutorConfig temp = parentFlowExecutorConfig;
            while(null!=temp){
                if(null!=temp.printTrace&&!temp.printTrace){
                    shouldPrintTrace = false;
                    break;
                }
                temp = temp.parentFlowExecutorConfig;
            }
        }
        if(null==shouldPrintTrace){
            shouldPrintTrace = flowExecutorRootConfig.flowConfig.printTrace;
        }
        if (shouldPrintTrace) {
            Integer flowLevel = flowExecutorRootConfig.flowLevel.get();
            if (null == flowLevel) {
                flowLevel = 0;
                flowExecutorRootConfig.flowLevel.set(flowLevel);
            }
            for (int i = 0; i < flowLevel; i++) {
                flowExecutorRootConfig.printTraceBuilder.append("\t");
            }
            flowExecutorRootConfig.printTraceBuilder.append(content + "\r\n");
        }
        if(flowExecutorRootConfig.flowConfig.debug){
            System.out.println(content);
        }
    }

    /**
     * 打印流程内容
     */
    public void printFlowTraceWithIndex(String content) {
        boolean shouldPrintTrace = null!=this.printTrace?this.printTrace:flowExecutorRootConfig.flowConfig.printTrace;
        if (shouldPrintTrace) {
            content = "[" + (flowExecutorRootConfig.index.getAndIncrement()) + "]"+content;
            printFlowTrace(content);
        }
    }

    /**
     * 获取备注记录
     * */
    public StringBuilder getRemarkBuilder(){
        StringBuilder remarkBuilder = flowExecutorRootConfig.remarkBuilderThreadLocal.get();
        if(null==remarkBuilder){
            flowExecutorRootConfig.remarkBuilderThreadLocal.set(new StringBuilder());
        }
        return flowExecutorRootConfig.remarkBuilderThreadLocal.get();
    }

    /**
     * 记录日志
     * */
    public void recordContent(String content){
        if(flowExecutorRootConfig.startRecord){
            flowExecutorRootConfig.recordBuilder.append("["+name+"]"+content+"\r\n");
        }
    }
}