package cn.schoolwow.quickflow.util;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.*;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.flow.HasFlowConfig;
import cn.schoolwow.quickflow.listener.LoadFlowConfig;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class QuickFlowUtil {
    /**
     * 获取流程列表名称
     * */
    public static List<String> getFlowNameList(FlowExecutorConfig flowExecutorConfig){
        List<String> flowNameList = new ArrayList<>();
        if(null!=flowExecutorConfig.tryCatchFinallyHandler){
            flowNameList.add("handler-tryCatchFinally:"+flowExecutorConfig.tryCatchFinallyHandler.name());
        }
        if(null!=flowExecutorConfig.beforeAfterFlowHandler){
            flowNameList.add("handler-beforeAfter:"+flowExecutorConfig.beforeAfterFlowHandler.name());
        }
        if(null!=flowExecutorConfig.singleFlowListener){
            flowNameList.add("handler-singleFlow:"+flowExecutorConfig.singleFlowListener.name());
        }
        for (BusinessFlow flow : flowExecutorConfig.flowList) {
            flowNameList.add(flow.name());
        }
        return flowNameList;
    }

    public static QuickFlowExecutor getCompositeQuickFlowExecutor(CompositeBusinessFlow compositeBusinessFlow, FlowExecutorConfig flowExecutorConfig) {
        FlowExecutorConfig compositeFlowExecutorConfig = new FlowExecutorConfig();
        compositeFlowExecutorConfig.name = compositeBusinessFlow.name();
        compositeFlowExecutorConfig.flowContext = new FlowContextImpl(compositeFlowExecutorConfig);
        compositeFlowExecutorConfig.currentCompositeFlowDataMap.set(new HashMap<>());
        compositeFlowExecutorConfig.flowExecutorRootConfig = flowExecutorConfig.flowExecutorRootConfig;
        compositeFlowExecutorConfig.compositeBusiness = true;
        QuickFlowExecutor compositeQuickFlowExecutor = new QuickFlowExecutor(compositeFlowExecutorConfig);
        compositeBusinessFlow.executeCompositeBusiness(compositeQuickFlowExecutor);
        loadFlowConfigByCompositeBusiness(compositeBusinessFlow, flowExecutorConfig);
        return compositeQuickFlowExecutor;
    }

    public static BusinessFlow getCompositeBusinessFlow(CompositeBusinessFlow compositeBusinessFlow){
        String compositeFlowName = "composite:"+compositeBusinessFlow.name();
        BusinessFlow businessFlow = new BusinessFlow() {
            @Override
            public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                FlowExecutorConfig flowExecutorConfig = flowContext.getFlowExecutorConfig();
                QuickFlowExecutor compositeQuickFlowExecutor = getCompositeQuickFlowExecutor(compositeBusinessFlow, flowExecutorConfig);
                compositeQuickFlowExecutor.execute();
            }

            @Override
            public String name() {
                return compositeFlowName;
            }
        };
        return businessFlow;
    }

    public static void loadFlowConfig(BusinessFlow flow, FlowExecutorConfig flowExecutorConfig) {
        FlowExecutorRootConfig flowExecutorRootConfig = flowExecutorConfig.flowExecutorRootConfig;
        FlowConfig flowConfig = flowExecutorConfig.flowExecutorRootConfig.flowConfig;

        if(flow instanceof HasFlowConfig){
            if(!flowConfig.flowConfigRequestDataMap.containsKey(flow.name())){
                HasFlowConfig hasFlowConfig = (HasFlowConfig) flow;
                JSONObject requestData = new JSONObject();
                hasFlowConfig.setRequestData(requestData);
                flowExecutorConfig.flowContext.putTemporaryData(requestData);
                flowConfig.flowConfigRequestDataMap.put(flow.name(), requestData);
            }
        }
        if(flow instanceof LoadFlowConfig){
            LoadFlowConfig loadFlowConfig = (LoadFlowConfig) flow;
            String[] flowNames = loadFlowConfig.getFlowNames();
            for(String flowName:flowNames) {
                if (!flowConfig.flowConfigRequestDataMap.containsKey(flowName)) {
                    //如果不存在，则从流程名称映射器获取，若获取成功则再次加载流程配置项
                    if(null!=flowConfig.flowMappingHandler){
                        CompositeBusinessFlow compositeBusinessFlow = flowConfig.flowMappingHandler.getCompositeBusinessFlow(flowName);
                        if(null!=compositeBusinessFlow){
                            QuickFlowUtil.loadFlowConfigByCompositeBusiness(compositeBusinessFlow, flowExecutorConfig);
                        }
                        BusinessFlow businessFlow = flowConfig.flowMappingHandler.getFlow(flowName);
                        if(null!=businessFlow){
                            QuickFlowUtil.loadFlowConfig(businessFlow, flowExecutorConfig);
                        }
                    }
                    if (!flowConfig.flowConfigRequestDataMap.containsKey(flowName)) {
                        throw new IllegalArgumentException("流程配置项不存在!流程名:" + flowName);
                    }
                }
                JSONObject requestData = flowConfig.flowConfigRequestDataMap.get(flowName);
                flowExecutorConfig.flowContext.putTemporaryData(requestData);
            }
        }

        if(flowConfig.flowConfigRequestDataMap.containsKey(flow.name())){
            JSONObject requestData = flowConfig.flowConfigRequestDataMap.get(flow.name());
            flowExecutorConfig.flowContext.putTemporaryData(requestData);

            if(!flowExecutorRootConfig.dataMap.containsKey("加载[普通流程]配置项记录")){
                flowExecutorRootConfig.dataMap.put("加载[普通流程]配置项记录", new JSONObject());
            }
            JSONObject log = (JSONObject) flowExecutorRootConfig.dataMap.get("加载[普通流程]配置项记录");
            log.put(flow.name(), requestData);
        }
    }

    public static void loadFlowConfigByCompositeBusiness(CompositeBusinessFlow compositeBusinessFlow, FlowExecutorConfig flowExecutorConfig) {
        FlowExecutorRootConfig flowExecutorRootConfig = flowExecutorConfig.flowExecutorRootConfig;
        FlowConfig flowConfig = flowExecutorConfig.flowExecutorRootConfig.flowConfig;

        if(compositeBusinessFlow instanceof HasFlowConfig){
            if(!flowConfig.flowConfigRequestDataMap.containsKey(compositeBusinessFlow.name())){
                HasFlowConfig hasFlowConfig = (HasFlowConfig) compositeBusinessFlow;
                JSONObject requestData = new JSONObject();
                hasFlowConfig.setRequestData(requestData);
                flowExecutorConfig.flowContext.putTemporaryData(requestData);
                flowConfig.flowConfigRequestDataMap.put(compositeBusinessFlow.name(), requestData);
            }
        }
        if(compositeBusinessFlow instanceof LoadFlowConfig){
            LoadFlowConfig loadFlowConfig = (LoadFlowConfig) compositeBusinessFlow;
            String[] flowNames = loadFlowConfig.getFlowNames();
            for(String flowName:flowNames) {
                if (!flowConfig.flowConfigRequestDataMap.containsKey(flowName)) {
                    //如果不存在，则从流程名称映射器获取，若获取成功则再次加载流程配置项
                    if(null!=flowConfig.flowMappingHandler){
                        CompositeBusinessFlow loadCompositeBusinessFlow = flowConfig.flowMappingHandler.getCompositeBusinessFlow(flowName);
                        if(null!=loadCompositeBusinessFlow){
                            QuickFlowUtil.loadFlowConfigByCompositeBusiness(loadCompositeBusinessFlow, flowExecutorConfig);
                        }
                        BusinessFlow businessFlow = flowConfig.flowMappingHandler.getFlow(flowName);
                        if(null!=businessFlow){
                            QuickFlowUtil.loadFlowConfig(businessFlow, flowExecutorConfig);
                        }
                    }
                    if (!flowConfig.flowConfigRequestDataMap.containsKey(flowName)) {
                        throw new IllegalArgumentException("流程配置项不存在!流程名:" + flowName);
                    }
                }
                JSONObject requestData = flowConfig.flowConfigRequestDataMap.get(flowName);
                flowExecutorConfig.flowContext.putTemporaryData(requestData);
            }
        }

        if(flowConfig.flowConfigRequestDataMap.containsKey(compositeBusinessFlow.name())){
            JSONObject requestData = flowConfig.flowConfigRequestDataMap.get(compositeBusinessFlow.name());
            flowExecutorConfig.flowContext.putTemporaryData(requestData);

            if(!flowExecutorRootConfig.dataMap.containsKey("加载[复合流程]配置项记录")){
                flowExecutorRootConfig.dataMap.put("加载[复合流程]配置项记录", new JSONObject());
            }
            JSONObject log = (JSONObject) flowExecutorRootConfig.dataMap.get("加载[复合流程]配置项记录");
            log.put(compositeBusinessFlow.name(), requestData);
        }
    }

}
