package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.listener.*;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlowConfig {
    /**
     * 是否开启调试模式
     */
    public boolean debug = false;

    /**
     * 是否打印执行路径
     */
    public boolean printTrace = true;

    /**
     * 流程日志记录层数
     */
    public int traceLevel = 1;

    /**
     * 是否忽略中断
     */
    public boolean ignoreBroken = true;

    /**
     * 是否忽略异常
     */
    public boolean ignoreException = false;

    /**
     * 全局上下文数据
     */
    public Map<String, Object> dataMap = new ConcurrentHashMap<>();

    /**
     * 全局流程配置对象
     */
    public Map<String, JSONObject> flowConfigRequestDataMap = new ConcurrentHashMap<>();

    /**
     * 是否所有流程都执行全局tryCatchFinally处理器
     */
    public boolean executeGlobalTryCatchFinally = false;

    /**
     * 是否所有流程都执行全局beforeAfter处理器
     */
    public boolean executeGlobalBeforeAfter = false;

    /**
     * 是否所有流程都执行全局singleFlow处理器
     */
    public boolean executeGlobalSingleFlow = false;

    /**
     * 流程执行前后事件监听
     */
    public SingleFlowListener singleFlowListener;

    /**
     * 流程名称和实例映射处理器
     */
    public FlowMappingHandler flowMappingHandler;

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * 主流程列表前后添加流程列表
     */
    public BeforeAfterFlowHandler beforeAfterFlowHandler;

    /**
     * 流程配置项处理器
     */
    public FlowConfigRequestDataHandler flowConfigRequestDataHandler;

}
