package cn.schoolwow.quickflow.util;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowContextImpl;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class QuickFlowUtil {
    /**
     * 获取流程列表名称
     * */
    public static List<String> getFlowNameList(FlowExecutorConfig flowExecutorConfig){
        List<String> flowNameList = new ArrayList<>();
        if(null!=flowExecutorConfig.tryCatchFinallyHandler){
            flowNameList.add("handler-tryCatchFinally:"+flowExecutorConfig.tryCatchFinallyHandler.name());
        }
        if(null!=flowExecutorConfig.beforeAfterFlowHandler){
            flowNameList.add("handler-beforeAfter:"+flowExecutorConfig.beforeAfterFlowHandler.name());
        }
        if(null!=flowExecutorConfig.singleFlowListener){
            flowNameList.add("handler-singleFlow:"+flowExecutorConfig.singleFlowListener.name());
        }
        for (BusinessFlow flow : flowExecutorConfig.flowList) {
            flowNameList.add(flow.name());
        }
        return flowNameList;
    }

    public static QuickFlowExecutor getCompositeQuickFlowExecutor(CompositeBusinessFlow compositeBusinessFlow, FlowExecutorConfig flowExecutorConfig){
        FlowExecutorConfig compositeFlowExecutorConfig = new FlowExecutorConfig();
        compositeFlowExecutorConfig.name = compositeBusinessFlow.name();
        compositeFlowExecutorConfig.flowContext = new FlowContextImpl(compositeFlowExecutorConfig);
        compositeFlowExecutorConfig.currentCompositeFlowDataMap.set(new HashMap<>());
        compositeFlowExecutorConfig.flowExecutorRootConfig = flowExecutorConfig.flowExecutorRootConfig;
        compositeFlowExecutorConfig.compositeBusiness = true;
        QuickFlowExecutor compositeQuickFlowExecutor = new QuickFlowExecutor(compositeFlowExecutorConfig);
        compositeBusinessFlow.executeCompositeBusiness(compositeQuickFlowExecutor);
        return compositeQuickFlowExecutor;
    }

    public static BusinessFlow getCompositeBusinessFlow(CompositeBusinessFlow compositeBusinessFlow){
        String compositeFlowName = "composite:"+compositeBusinessFlow.name();
        BusinessFlow businessFlow = new BusinessFlow() {
            @Override
            public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                FlowExecutorConfig flowExecutorConfig = flowContext.getFlowExecutorConfig();
                QuickFlowExecutor compositeQuickFlowExecutor = getCompositeQuickFlowExecutor(compositeBusinessFlow, flowExecutorConfig);
                compositeQuickFlowExecutor.execute();
            }

            @Override
            public String name() {
                return compositeFlowName;
            }
        };
        return businessFlow;
    }

}
