package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FlowExecutorRootConfig {
    /**
     * 流程名称
     */
    public String name;

    /**
     * 流程备注记录
     */
    public StringBuilder remarkBuilder = new StringBuilder();

    /**
     * 上下文数据
     */
    public Map<String, Object> dataMap = new ConcurrentHashMap<>();

    /**
     * 线程本地数据
     */
    public ThreadLocal<Map<String, Object>> threadLocalDataMap = new ThreadLocal<>();

    /**
     * 临时数据key
     * */
    public Set<String> temporaryKeySet = new HashSet<>();

    /**
     * 请求数据
     * */
    public Set<String> requestKeySet = new HashSet<>();

    /**
     * 是否打印流程列表
     * */
    public boolean printTrace = true;

    /**
     * 打印执行路径
     */
    public StringBuilder printTraceBuilder;

    /**
     * 业务流程列表
     */
    public List<BusinessFlow> flowList = new ArrayList<>();
    
    /**
     * 流程名称列表
     */
    public List<String> flowNameList = new ArrayList<>();

    /**
     * 单个流程事件处理
     */
    public SingleFlowListener singleFlowListener;

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * before-after流程列表
     */
    public BeforeAfterFlowHandler beforeAfterFlowHandler;

    /**
     * 是否忽略异常
     * */
    public boolean ignoreException;

    /**
     * 流程异常
     * */
    public Exception exception;

    /**
     * 中断原因
     * */
    public String brokenReason;

    /**
     * 流程上下文对象
     * */
    public FlowContext flowContext;

    /**
     * 流程下标
     */
    public AtomicInteger index = new AtomicInteger(0);

    /**
     * 流程层级
     */
    public ThreadLocal<Integer> flowLevel = new ThreadLocal<Integer>();

    /**
     * 全局流程配置
     * */
    public FlowConfig flowConfig;

    /**
     * QuickFlow对象
     * */
    public QuickFlow quickFlow;

    /**打印流程内容*/
    public void printFlowTrace(String content){
        if (printTrace&&flowConfig.printTrace) {
            Integer flowLevel = this.flowLevel.get();
            if(null==flowLevel){
                flowLevel = 1;
                this.flowLevel.set(flowLevel);
            }
            for(int i=0;i<flowLevel;i++){
                printTraceBuilder.append("\t");
            }
            printTraceBuilder.append(content + "\r\n");
        }
    }

    /**增加层级*/
    public void incrementFlowLevel(){
        Integer flowLevel = this.flowLevel.get();
        if(null==flowLevel){
            this.flowLevel.set(1);
        }else{
            int newFlowLevel = flowLevel+1;
            this.flowLevel.set(newFlowLevel);
        }
    }

    /**减少层级*/
    public void decrementFlowLevel(){
        Integer flowLevel = this.flowLevel.get();
        if(null==flowLevel){
            this.flowLevel.set(0);
        }else{
            int newFlowLevel = flowLevel-1;
            this.flowLevel.set(newFlowLevel);
        }
    }
}
