package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.FlowNameInstanceMappingHandler;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlowConfig {
    /**
     * 事件监听列表
     */
    public SingleFlowListener singleFlowListener;

    /**
     * 流程名称和实例映射
     */
    public FlowNameInstanceMappingHandler flowNameInstanceMappingHandler;

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * before-after流程列表
     */
    public BeforeAfterFlowHandler beforeAfterFlowHandler;

    /**
     * 是否打印执行路径
     */
    public boolean printTrace;

    /**
     * 是否打印执行时间
     */
    public boolean printConsumeTime;

    /**
     * 保存复合流程
     * */
    public Map<String, BusinessFlow> businessMap = new ConcurrentHashMap<>();
}
