package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;

import java.util.List;
import java.util.Map;

/**
 * 上下文对象
 */
public interface FlowContext {
    /**
     * 返回流程唯一标识
     * */
    long getId();

    /**
     * 打印日志
     */
    FlowContext printTrace(boolean printTrace);

    /**
     * 忽略中断
     */
    FlowContext ignoreBroken(boolean ignoreBroken);

    /**
     * 忽略异常
     */
    FlowContext ignoreException(boolean ignoreException);

    /**
     * 是否所有流程都执行全局tryCatchFinally处理器
     */
    FlowContext executeGlobalTryCatchFinally(boolean executeGlobalTryCatchFinally);

    /**
     * 是否所有流程都执行全局beforeAfter处理器
     */
    FlowContext executeGlobalBeforeAfter(boolean executeGlobalBeforeAfter);

    /**
     * 是否所有流程都执行全局singleFlow处理器
     */
    FlowContext executeGlobalSingleFlow(boolean executeGlobalSingleFlow);

    /**
     * 判断key是否存在
     */
    boolean containKey(String key);

    /**
     * 获取上下文数据,不存在时抛出异常
     */
    Object checkData(String key);

    /**
     * 获取上下文数据,不存在时抛出异常
     */
    <T> T checkData(String key, Class<T> clazz);

    /**
     * 获取上下文数据,获取后删除,不存在时抛出异常
     */
    Object useData(String key);

    /**
     * 获取上下文数据,获取后删除,不存在时抛出异常
     */
    <T> T useData(String key, Class<T> clazz);

    /**
     * 获取上下文数据
     */
    Object getData(String key);

    /**
     * 获取上下文数据
     */
    <T> T getData(String key, Class<T> clazz);

    /**
     * 获取上下文数据
     */
    Object getData(String key, Object defaultValue);

    /**
     * 获取上下文数据
     */
    <T> T getData(String key, Class<T> clazz, T defaultValue);

    /**
     * 获取上下文数据
     */
    Map<String,Object> getData();

    /**
     * 获取临时数据key
     */
    Map<String, Object> getTemporaryDataMap();

    /**
     * 获取线程上下文数据
     */
    Map<String, Object> getThreadLocalDataMap();

    /**
     * 获取请求数据
     */
    Map<String, Object> getRequestDataMap();

    /**
     * 获取上下文数据
     */
    Map<String, Object> getContextDataMap();

    /**
     * 设置上下文数据
     */
    void putData(String key, Object value);

    /**
     * 设置上下文数据
     */
    void putData(Map<String, Object> map);

    /**
     * 设置临时数据
     */
    void putTemporaryData(String key, Object value);

    /**
     * 设置临时数据
     */
    void putTemporaryData(Map<String, Object> map);

    /**
     * 设置线程本地数据
     */
    void putThreadLocalData(String key, Object value);

    /**
     * 设置线程本地数据
     */
    void putThreadLocalData(Map<String, Object> map);

    /**
     * 移除上下文数据
     */
    void removeData(String key);

    /**
     * 移除线程本地数据
     */
    void removeThreadLocalData(String key);

    /**
     * 流程备注
     */
    void remark(String remark);

    /**
     * 中断当前流程
     * @param reason 中断原因
     */
    void brokenCurrentFlow(String reason);

    /**
     * 中断流程
     * @param reason 中断原因
     */
    void broken(String reason);

    /**
     * 获取主流程名
     */
    String getFlowName();

    /**
     * 获取流程列表
     */
    List<String> getFlowNameList();

    /**
     * 获取流程日志
     */
    String getFlowTrace();

    /**
     * 获取流程异常
     */
    Exception getFlowException();

    /**
     * 获取流程中断原因
     */
    String getBrokenReason();

    /**
     * 创建流程
     * */
    QuickFlowExecutor startFlow(String name);

    /**
     * 创建流程
     * */
    QuickFlowExecutor startFlow(BusinessFlow businessFlow);

    /**
     * 创建流程
     * */
    QuickFlowExecutor startFlow(CompositeBusinessFlow compositeBusinessFlow);

    /**
     * 执行流程列表
     */
    FlowContext executeFlowList(BusinessFlow... businessFlowList);

    /**
     * 执行复合流程
     */
    FlowContext executeQuickFlowExecutor(QuickFlowExecutor quickFlowExecutor);

    /**
     * 执行复合流程列表
     */
    FlowContext executeCompositeFlowList(CompositeBusinessFlow... compositeBusinessFlowList);

    /**
     * 获取配置项
     * */
    FlowExecutorConfig getFlowExecutorConfig();

    /**
     * 获取配置项
     * */
    FlowExecutorRootConfig getFlowExecutorRootConfig();

    /**
     * 获取流程
     * */
    QuickFlow getQuickFlow();

    /**
     * 获取日志记录
     * */
    String getRecord();
}
