package cn.schoolwow.quickflow.listener;

import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;

/**
 * 流程名称映射
 * */
public interface FlowNameInstanceMappingHandler {
    /**
     * 根据流程名称获取实例
     * */
    BusinessFlow getFlowByName(String flowName);

    /**
     * 根据流程名称获取实例
     * */
    CompositeBusinessFlow getCompositeFlowByName(String flowName);

    /**
     * 根据名称获取try-catch-finally事件处理器
     * */
    TryCatchFinallyHandler getTryCatchFinallyHandlerByName(String handlerName);

    /**
     * 根据名称获取before-after事件处理器
     * */
    BeforeAfterFlowHandler getBeforeAfterHandlerByName(String handlerName);

    /**
     * 根据名称获取singleFlow事件处理器
     * */
    SingleFlowListener getSingleFlowListener(String handlerName);
}
