package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.FlowNameInstanceMappingHandler;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

public class FlowConfig {
    /**
     * 是否打印执行路径
     */
    public boolean printTrace = true;

    /**
     * 是否忽略中断
     */
    public boolean ignoreBroken = true;

    /**
     * 是否忽略异常
     */
    public boolean ignoreException = false;

    /**
     * 是否所有流程都执行全局tryCatchFinally处理器
     */
    public boolean executeGlobalTryCatchFinally = false;

    /**
     * 是否所有流程都执行全局beforeAfter处理器
     */
    public boolean executeGlobalBeforeAfter = false;

    /**
     * 是否所有流程都执行全局singleFlow处理器
     */
    public boolean executeGlobalSingleFlow = false;

    /**
     * 流程执行前后事件监听
     */
    public SingleFlowListener singleFlowListener;

    /**
     * 流程名称和实例映射处理器
     */
    public FlowNameInstanceMappingHandler flowNameInstanceMappingHandler;

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * 主流程列表前后添加流程列表
     */
    public BeforeAfterFlowHandler beforeAfterFlowHandler;

}
