package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FlowExecutorConfig {
    /**
     * 是否执行全局事件
     * */
    public Boolean executeGlobalEvent;

    /**
     * 流程名称
     */
    public String name;

    /**
     * 是否打印流程列表
     */
    public Boolean printTrace;

    /**
     * 是否忽略中断
     */
    public Boolean ignoreBroken;

    /**
     * 是否忽略异常
     */
    public Boolean ignoreException;

    /**
     * 当前流程
     * */
    public BusinessFlow currentFlow;

    /**
     * 业务流程列表
     */
    public List<BusinessFlow> flowList = new ArrayList<>();

    /**
     * 流程名称列表
     */
    public List<String> flowNameList = new ArrayList<>();

    /**
     * 临时数据key
     */
    public Set<String> temporaryDataKeySet = new HashSet<>();

    /**
     * 单个流程事件处理
     */
    public SingleFlowListener singleFlowListener;

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * before-after流程列表
     */
    public BeforeAfterFlowHandler beforeAfterFlowHandler;

    /**
     * 上级流程配置
     */
    public FlowExecutorConfig parentFlowExecutorConfig;

    /**
     * 主流程配置
     */
    public FlowExecutorRootConfig flowExecutorRootConfig;

    /**
     * 打印流程内容
     */
    public void printFlowTrace(String content) {
        if (printTrace) {
            Integer flowLevel = flowExecutorRootConfig.flowLevel.get();
            if (null == flowLevel) {
                flowLevel = 0;
                flowExecutorRootConfig.flowLevel.set(flowLevel);
            }
            for (int i = 0; i < flowLevel; i++) {
                flowExecutorRootConfig.printTraceBuilder.append("\t");
            }
            flowExecutorRootConfig.printTraceBuilder.append(content + "\r\n");
        }
    }

    /**
     * 打印流程内容
     */
    public void printFlowTraceWithIndex(String content) {
        if (printTrace) {
            content = "[" + (flowExecutorRootConfig.index.getAndIncrement()) + "]"+content;
            printFlowTrace(content);
        }
    }

    /**
     * 获取备注记录
     * */
    public StringBuilder getRemarkBuilder(){
        StringBuilder remarkBuilder = flowExecutorRootConfig.remarkBuilderThreadLocal.get();
        if(null==remarkBuilder){
            flowExecutorRootConfig.remarkBuilderThreadLocal.set(new StringBuilder());
        }
        return flowExecutorRootConfig.remarkBuilderThreadLocal.get();
    }

    /**
     * 记录日志
     * */
    public void recordContent(String content){
        if(flowExecutorRootConfig.startRecord){
            flowExecutorRootConfig.recordBuilder.append("["+name+"]"+content+"\r\n");
        }
    }
}