package cn.schoolwow.quickflow.util;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;

import java.util.Map;

public class QuickFlowUtil {

    /**
     * 获取复合流程执行器
     * @param sourceFlowExecutorConfig 原始流程
     * @param compositeFlowExecutorConfig 复合流程
     * */
    public static QuickFlowExecutor getCompositeExecutor(FlowExecutorConfig sourceFlowExecutorConfig, FlowExecutorConfig compositeFlowExecutorConfig){
        //注意值引用问题
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        {
            flowExecutorConfig.name = compositeFlowExecutorConfig.name;
            flowExecutorConfig.printTrace = compositeFlowExecutorConfig.printTrace;
            flowExecutorConfig.ignoreBroken = compositeFlowExecutorConfig.ignoreBroken;
            flowExecutorConfig.ignoreException = compositeFlowExecutorConfig.ignoreException;
            flowExecutorConfig.flowList = compositeFlowExecutorConfig.flowList;
            flowExecutorConfig.flowNameList = compositeFlowExecutorConfig.flowNameList;
            flowExecutorConfig.singleFlowListener = compositeFlowExecutorConfig.singleFlowListener;
            flowExecutorConfig.tryCatchFinallyHandler = compositeFlowExecutorConfig.tryCatchFinallyHandler;
            flowExecutorConfig.beforeAfterFlowHandler = compositeFlowExecutorConfig.beforeAfterFlowHandler;
            flowExecutorConfig.parentFlowExecutorConfig = sourceFlowExecutorConfig;
            flowExecutorConfig.flowExecutorRootConfig = sourceFlowExecutorConfig.flowExecutorRootConfig;
        }
        //合并配置
        {
            flowExecutorConfig.flowExecutorRootConfig.dataMap.putAll(compositeFlowExecutorConfig.flowExecutorRootConfig.dataMap);
            flowExecutorConfig.flowExecutorRootConfig.temporaryDataMap.putAll(compositeFlowExecutorConfig.flowExecutorRootConfig.temporaryDataMap);
            flowExecutorConfig.flowExecutorRootConfig.requestKeySet.addAll(compositeFlowExecutorConfig.flowExecutorRootConfig.requestKeySet);
            Map<String, Object> sourceThreadLocalMap = flowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
            Map<String, Object> targetThreadLocalMap = compositeFlowExecutorConfig.flowExecutorRootConfig.threadLocalDataMap.get();
            if(null!=sourceThreadLocalMap&&null!=targetThreadLocalMap){
                sourceThreadLocalMap.putAll(targetThreadLocalMap);
            }
        }
        QuickFlowExecutor quickFlowExecutor = new QuickFlowExecutor(flowExecutorConfig);
        return quickFlowExecutor;
    }

}
