/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.domain.ExecuteFlowListOption;
import cn.schoolwow.quickflow.domain.ExecuteFlowListOptionBuilder;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorRootConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlowContextImpl
implements FlowContext {
    private FlowExecutorRootConfig flowExecutorRootConfig;

    public FlowContextImpl(FlowExecutorRootConfig flowExecutorRootConfig) {
        this.flowExecutorRootConfig = flowExecutorRootConfig;
    }

    @Override
    public Object checkData(String key) {
        Object value = this.getData(key);
        if (null == value) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return value;
    }

    @Override
    public <T> T checkData(String key, Class<T> clazz) {
        T value = this.getData(key, clazz);
        if (null == value) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return value;
    }

    @Override
    public Object getData(String key) {
        Object value = this.flowExecutorRootConfig.dataMap.get(key);
        if (null != value) {
            return value;
        }
        Map<String, Object> threadLocalMap = this.flowExecutorRootConfig.threadLocalDataMap.get();
        if (null == threadLocalMap) {
            return null;
        }
        return threadLocalMap.get(key);
    }

    @Override
    public <T> T getData(String key, Class<T> clazz) {
        Object value = this.getData(key);
        if (value instanceof JSONObject) {
            JSONObject o = (JSONObject)value;
            return (T)o.toJavaObject(clazz);
        }
        if (value instanceof JSONArray) {
            JSONArray o = (JSONArray)value;
            return (T)o.toJavaObject(clazz);
        }
        try {
            T t = clazz.cast(value);
            return t;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("\u65e0\u6cd5\u8f6c\u6362\u7c7b\u578b!\u9884\u671f\u7c7b\u578b:" + clazz.getName() + ",\u5b9e\u9645\u7c7b\u578b:" + value.getClass().getName());
        }
    }

    @Override
    public Object getData(String key, Object defaultValue) {
        Object value = this.getData(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz, T defaultValue) {
        T value = this.getData(key, clazz);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Map<String, Object> getData() {
        Map<String, Object> dataMap = this.flowExecutorRootConfig.dataMap;
        Map<String, Object> threadLocalMap = this.flowExecutorRootConfig.threadLocalDataMap.get();
        if (null != threadLocalMap) {
            dataMap.putAll(threadLocalMap);
        }
        return dataMap;
    }

    @Override
    public void putData(String key, Object value) {
        if (null != key && null != value) {
            this.flowExecutorRootConfig.dataMap.put(key, value);
        }
    }

    @Override
    public void putData(Map<String, Object> map) {
        if (null != map) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                if (null != iterator.next().getValue()) continue;
                iterator.remove();
            }
            this.flowExecutorRootConfig.dataMap.putAll(map);
        }
    }

    @Override
    public Map<String, Object> getTemporaryDataMap() {
        HashMap<String, Object> temporaryDataMap = new HashMap<String, Object>();
        for (String key : this.flowExecutorRootConfig.temporaryKeySet) {
            temporaryDataMap.put(key, this.flowExecutorRootConfig.dataMap.get(key));
        }
        return temporaryDataMap;
    }

    @Override
    public Map<String, Object> getThreadLocalDataMap() {
        Map<String, Object> threadLocalMap = this.flowExecutorRootConfig.threadLocalDataMap.get();
        return threadLocalMap;
    }

    @Override
    public Map<String, Object> getRequestDataMap() {
        HashMap<String, Object> requestDataMap = new HashMap<String, Object>();
        for (String key : this.flowExecutorRootConfig.requestKeySet) {
            requestDataMap.put(key, this.flowExecutorRootConfig.dataMap.get(key));
        }
        return requestDataMap;
    }

    @Override
    public Map<String, Object> getContextDataMap() {
        HashSet<String> keySet = new HashSet<String>(this.flowExecutorRootConfig.dataMap.keySet());
        keySet.removeAll(this.flowExecutorRootConfig.requestKeySet);
        keySet.removeAll(this.flowExecutorRootConfig.temporaryKeySet);
        HashMap<String, Object> contextDataMap = new HashMap<String, Object>();
        for (String key : keySet) {
            contextDataMap.put(key, this.flowExecutorRootConfig.dataMap.get(key));
        }
        return contextDataMap;
    }

    @Override
    public void putTemporaryData(String key, Object value) {
        this.putData(key, value);
        if (null != key) {
            this.flowExecutorRootConfig.temporaryKeySet.add(key);
        }
    }

    @Override
    public void putTemporaryData(Map<String, Object> map) {
        this.putData(map);
        if (null != map) {
            this.flowExecutorRootConfig.temporaryKeySet.addAll(map.keySet());
        }
    }

    @Override
    public void putThreadLocalData(String key, Object value) {
        if (null != key && null != value) {
            Map<String, Object> threadLocalMap = this.flowExecutorRootConfig.threadLocalDataMap.get();
            if (null == threadLocalMap) {
                threadLocalMap = new HashMap<String, Object>();
                this.flowExecutorRootConfig.threadLocalDataMap.set(threadLocalMap);
            }
            threadLocalMap.put(key, value);
        }
    }

    @Override
    public void putThreadLocalData(Map<String, Object> map) {
        if (null != map) {
            Map<String, Object> threadLocalMap = this.flowExecutorRootConfig.threadLocalDataMap.get();
            if (null == threadLocalMap) {
                threadLocalMap = new HashMap<String, Object>();
                this.flowExecutorRootConfig.threadLocalDataMap.set(threadLocalMap);
            }
            threadLocalMap.putAll(map);
        }
    }

    @Override
    public void removeData(String key) {
        if (null != key) {
            this.flowExecutorRootConfig.dataMap.remove(key);
        }
    }

    @Override
    public void remark(String remark) {
        this.flowExecutorRootConfig.remarkBuilder.append("|" + remark);
    }

    @Override
    public void brokenCurrentFlow(String reason) {
        throw new BrokenCurrentFlowException(reason);
    }

    @Override
    public void broken(String reason) {
        throw new BrokenException(reason);
    }

    @Override
    public String getFlowName() {
        return this.flowExecutorRootConfig.name;
    }

    @Override
    public List<String> getFlowNameList() {
        return this.flowExecutorRootConfig.flowNameList;
    }

    @Override
    public String getFlowTrace() {
        return this.flowExecutorRootConfig.printTraceBuilder.toString();
    }

    @Override
    public Exception getFlowException() {
        return this.flowExecutorRootConfig.exception;
    }

    @Override
    public String getBrokenReason() {
        return this.flowExecutorRootConfig.brokenReason;
    }

    @Override
    public FlowContext executeFlowList(BusinessFlow ... businessFlowList) throws Exception {
        return this.executeFlowList(new ExecuteFlowListOption(), businessFlowList);
    }

    @Override
    public FlowContext executeFlowList(String name, BusinessFlow ... businessFlowList) throws Exception {
        return this.executeFlowList(ExecuteFlowListOptionBuilder.get().name(name).build(), businessFlowList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowContext executeFlowList(ExecuteFlowListOption executeFlowListOption, BusinessFlow ... businessFlowList) throws Exception {
        block21: {
            if (null != executeFlowListOption && executeFlowListOption.printTrace && null != executeFlowListOption.name) {
                this.flowExecutorRootConfig.printFlowTrace("[" + executeFlowListOption.name + "]");
            }
            this.flowExecutorRootConfig.incrementFlowLevel();
            BusinessFlow currentFlow = null;
            try {
                BusinessFlow[] businessFlowArray = businessFlowList;
                int n = businessFlowArray.length;
                for (int i = 0; i < n; ++i) {
                    long endTime;
                    BusinessFlow businessFlow;
                    currentFlow = businessFlow = businessFlowArray[i];
                    long startTime = System.currentTimeMillis();
                    boolean hasBrokenCurrentFlowException = false;
                    try {
                        businessFlow.executeBusinessFlow(this);
                    }
                    catch (BrokenCurrentFlowException e) {
                        block20: {
                            try {
                                hasBrokenCurrentFlowException = true;
                                long endTime2 = System.currentTimeMillis();
                                if (null == executeFlowListOption || !executeFlowListOption.printTrace) break block20;
                                this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + (this.flowExecutorRootConfig.flowConfig.printConsumeTime ? "|" + (endTime2 - startTime) + "\u6beb\u79d2|" : "") + "|[x]|" + businessFlow.name() + "|\u5f53\u524d\u6d41\u7a0b\u4e2d\u65ad|\u4e2d\u65ad\u539f\u56e0:" + e.getReason() + this.flowExecutorRootConfig.remarkBuilder.toString());
                            }
                            catch (Throwable throwable) {
                                long endTime3 = System.currentTimeMillis();
                                if (!hasBrokenCurrentFlowException && null != executeFlowListOption && executeFlowListOption.printTrace) {
                                    this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + (this.flowExecutorRootConfig.flowConfig.printConsumeTime ? "|" + (endTime3 - startTime) + "\u6beb\u79d2|" : "") + businessFlow.name() + this.flowExecutorRootConfig.remarkBuilder.toString());
                                }
                                this.flowExecutorRootConfig.remarkBuilder.setLength(0);
                                throw throwable;
                            }
                        }
                        endTime = System.currentTimeMillis();
                        if (!hasBrokenCurrentFlowException && null != executeFlowListOption && executeFlowListOption.printTrace) {
                            this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + (this.flowExecutorRootConfig.flowConfig.printConsumeTime ? "|" + (endTime - startTime) + "\u6beb\u79d2|" : "") + businessFlow.name() + this.flowExecutorRootConfig.remarkBuilder.toString());
                        }
                        this.flowExecutorRootConfig.remarkBuilder.setLength(0);
                        continue;
                    }
                    endTime = System.currentTimeMillis();
                    if (!hasBrokenCurrentFlowException && null != executeFlowListOption && executeFlowListOption.printTrace) {
                        this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + (this.flowExecutorRootConfig.flowConfig.printConsumeTime ? "|" + (endTime - startTime) + "\u6beb\u79d2|" : "") + businessFlow.name() + this.flowExecutorRootConfig.remarkBuilder.toString());
                    }
                    this.flowExecutorRootConfig.remarkBuilder.setLength(0);
                    continue;
                }
            }
            catch (BrokenException e) {
                if (null != executeFlowListOption && executeFlowListOption.printTrace) {
                    this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]|[x]|" + currentFlow.name() + "|\u4e1a\u52a1\u6d41\u7a0b\u7ec8\u6b62|\u539f\u56e0:" + e.getReason());
                }
            }
            catch (Exception e) {
                if (null != executeFlowListOption && executeFlowListOption.printTrace) {
                    this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]|[x]|" + currentFlow.name() + "|\u4e1a\u52a1\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38|\u5f02\u5e38\u4fe1\u606f:" + e.getClass().getName() + "-" + e.getMessage());
                }
                if (null != executeFlowListOption && executeFlowListOption.ignoreException) {
                    e.printStackTrace();
                    break block21;
                }
                throw e;
            }
            finally {
                this.flowExecutorRootConfig.decrementFlowLevel();
                if (null != executeFlowListOption && executeFlowListOption.printTrace && null != executeFlowListOption.name) {
                    this.flowExecutorRootConfig.printFlowTrace("[" + executeFlowListOption.name + "]");
                }
            }
        }
        return this;
    }

    @Override
    public BusinessFlow getBusinessFlow(String flowName) {
        BusinessFlow businessFlow = this.flowExecutorRootConfig.flowConfig.businessMap.get(flowName);
        if (null == businessFlow) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728!\u8bf7\u5148\u8c03\u7528save\u65b9\u6cd5\u4fdd\u5b58\u8be5\u6d41\u7a0b!\u6d41\u7a0b\u540d\u79f0:" + flowName);
        }
        return businessFlow;
    }
}

