/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.domain.FlowExecutorRootConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickFlowExecutor {
    private Logger logger = LoggerFactory.getLogger(QuickFlowExecutor.class);
    private FlowExecutorRootConfig flowExecutorRootConfig;

    public QuickFlowExecutor(FlowExecutorRootConfig flowExecutorRootConfig) {
        this.flowExecutorRootConfig = flowExecutorRootConfig;
    }

    public QuickFlowExecutor putData(String key, Object value) {
        this.flowExecutorRootConfig.flowContext.putData(key, value);
        this.flowExecutorRootConfig.requestKeySet.add(key);
        return this;
    }

    public QuickFlowExecutor putData(Map<String, Object> dataMap) {
        this.flowExecutorRootConfig.flowContext.putData(dataMap);
        this.flowExecutorRootConfig.requestKeySet.addAll(dataMap.keySet());
        return this;
    }

    public QuickFlowExecutor putTemporaryData(String key, Object value) {
        this.flowExecutorRootConfig.flowContext.putTemporaryData(key, value);
        this.flowExecutorRootConfig.requestKeySet.add(key);
        return this;
    }

    public QuickFlowExecutor putTemporaryData(Map<String, Object> dataMap) {
        this.flowExecutorRootConfig.flowContext.putTemporaryData(dataMap);
        this.flowExecutorRootConfig.requestKeySet.addAll(dataMap.keySet());
        return this;
    }

    public QuickFlowExecutor putThreadLocalData(String key, Object value) {
        this.flowExecutorRootConfig.flowContext.putThreadLocalData(key, value);
        return this;
    }

    public QuickFlowExecutor putThreadLocalData(Map<String, Object> dataMap) {
        this.flowExecutorRootConfig.flowContext.putThreadLocalData(dataMap);
        return this;
    }

    public QuickFlowExecutor next(String flowName) {
        if (null == this.flowExecutorRootConfig.flowConfig.flowNameInstanceMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        BusinessFlow flow = this.flowExecutorRootConfig.flowConfig.flowNameInstanceMappingHandler.getFlowByName(flowName);
        this.flowExecutorRootConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor next(BusinessFlow flow) {
        this.flowExecutorRootConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        this.flowExecutorRootConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    public QuickFlowExecutor beforeAfterFlowHandler(BeforeAfterFlowHandler beforeAfterFlowHandler) {
        this.flowExecutorRootConfig.beforeAfterFlowHandler = beforeAfterFlowHandler;
        return this;
    }

    public QuickFlowExecutor printTrace(boolean printTrace) {
        this.flowExecutorRootConfig.printTrace = printTrace;
        return this;
    }

    public QuickFlowExecutor ignoreException(boolean ignoreException) {
        this.flowExecutorRootConfig.ignoreException = ignoreException;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowContext execute() throws Exception {
        if (this.flowExecutorRootConfig.printTrace && this.flowExecutorRootConfig.flowConfig.printTrace) {
            this.flowExecutorRootConfig.flowNameList.addAll(this.getFlowNameList());
        }
        BusinessFlow currentFlow = this.flowExecutorRootConfig.flowList.get(0);
        try {
            this.executeTryCatchFinallyHandler(this.flowExecutorRootConfig.tryCatchFinallyHandler, "try", null);
            this.executeTryCatchFinallyHandler(this.flowExecutorRootConfig.flowConfig.tryCatchFinallyHandler, "try", null);
            this.executeBeforeAfterFlowHandler(this.flowExecutorRootConfig.beforeAfterFlowHandler);
            this.executeBeforeAfterFlowHandler(this.flowExecutorRootConfig.flowConfig.beforeAfterFlowHandler);
            this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.name + "]");
            this.flowExecutorRootConfig.incrementFlowLevel();
            Iterator<BusinessFlow> iterator = this.flowExecutorRootConfig.flowList.iterator();
            while (iterator.hasNext()) {
                BusinessFlow flow;
                currentFlow = flow = iterator.next();
                if (null != this.flowExecutorRootConfig.flowConfig.quickFlowListener) {
                    this.flowExecutorRootConfig.flowConfig.quickFlowListener.beforeExecuteFlow(flow, this.flowExecutorRootConfig.flowContext);
                }
                long startTime = System.currentTimeMillis();
                try {
                    flow.executeBusinessFlow(this.flowExecutorRootConfig.flowContext);
                    long endTime = System.currentTimeMillis();
                    this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + (this.flowExecutorRootConfig.flowConfig.printConsumeTime ? "|" + (endTime - startTime) + "\u6beb\u79d2|" : "") + flow.name() + this.flowExecutorRootConfig.remarkBuilder.toString());
                }
                catch (BrokenCurrentFlowException e) {
                    long endTime = System.currentTimeMillis();
                    this.flowExecutorRootConfig.brokenReason = e.getReason();
                    this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + (this.flowExecutorRootConfig.flowConfig.printConsumeTime ? "|" + (endTime - startTime) + "\u6beb\u79d2|" : "") + "|[x]|" + flow.name() + "|\u5f53\u524d\u6d41\u7a0b\u4e2d\u65ad|\u4e2d\u65ad\u539f\u56e0:" + e.getReason() + this.flowExecutorRootConfig.remarkBuilder.toString());
                }
                finally {
                    this.flowExecutorRootConfig.remarkBuilder.setLength(0);
                }
                if (null == this.flowExecutorRootConfig.flowConfig.quickFlowListener) continue;
                this.flowExecutorRootConfig.flowConfig.quickFlowListener.afterExecuteFlow(flow, this.flowExecutorRootConfig.flowContext);
            }
        }
        catch (BrokenException e) {
            this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]" + currentFlow.name() + this.flowExecutorRootConfig.remarkBuilder.toString());
            this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]|[x]|\u4e1a\u52a1\u6d41\u7a0b\u7ec8\u6b62|\u539f\u56e0:" + e.getReason());
            this.flowExecutorRootConfig.brokenReason = e.getReason();
            return this.flowExecutorRootConfig.brokenReason;
        }
        catch (Exception e) {
            this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.index.getAndIncrement() + "]|[x]|" + currentFlow.name() + "|\u4e1a\u52a1\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38|\u5f02\u5e38\u4fe1\u606f:" + e.getClass().getName() + "-" + e.getMessage());
            this.executeTryCatchFinallyHandler(this.flowExecutorRootConfig.tryCatchFinallyHandler, "catch", e);
            this.executeTryCatchFinallyHandler(this.flowExecutorRootConfig.flowConfig.tryCatchFinallyHandler, "catch", e);
            this.flowExecutorRootConfig.exception = e;
            if (this.flowExecutorRootConfig.ignoreException) {
                e.printStackTrace();
            }
            throw e;
        }
        finally {
            this.flowExecutorRootConfig.decrementFlowLevel();
            this.flowExecutorRootConfig.printFlowTrace("[" + this.flowExecutorRootConfig.name + "]");
            this.executeTryCatchFinallyHandler(this.flowExecutorRootConfig.tryCatchFinallyHandler, "finally", null);
            this.executeTryCatchFinallyHandler(this.flowExecutorRootConfig.flowConfig.tryCatchFinallyHandler, "finally", null);
            Set<String> temporaryKeySet = this.flowExecutorRootConfig.temporaryKeySet;
            for (String temporaryKey : temporaryKeySet) {
                this.flowExecutorRootConfig.dataMap.remove(temporaryKey);
            }
        }
        return this.flowExecutorRootConfig.flowContext;
    }

    public FlowExecutorOption save() {
        if (this.flowExecutorRootConfig.flowConfig.businessMap.containsKey(this.flowExecutorRootConfig.name)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u4fdd\u5b58\u8be5\u6d41\u7a0b!\u6d41\u7a0b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!\u6d41\u7a0b\u540d\u79f0:" + this.flowExecutorRootConfig.name);
        }
        BusinessFlow businessFlow = new BusinessFlow(){

            @Override
            public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                QuickFlowExecutor quickFlowExecutor = ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.quickFlow.startFlow(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.name).putData(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.dataMap);
                if (null != ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.tryCatchFinallyHandler) {
                    quickFlowExecutor.tryCatchFinallyHandler(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.tryCatchFinallyHandler);
                }
                if (null != ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.beforeAfterFlowHandler) {
                    quickFlowExecutor.beforeAfterFlowHandler(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.beforeAfterFlowHandler);
                }
                for (BusinessFlow flow : ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.flowList) {
                    quickFlowExecutor.next(flow);
                }
                quickFlowExecutor.execute();
            }

            @Override
            public String name() {
                return ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorRootConfig.name;
            }
        };
        this.flowExecutorRootConfig.flowConfig.businessMap.put(this.flowExecutorRootConfig.name, businessFlow);
        FlowExecutorOption flowExecutorOption = new FlowExecutorOption();
        flowExecutorOption.name = this.flowExecutorRootConfig.name;
        flowExecutorOption.requestData = this.flowExecutorRootConfig.dataMap;
        flowExecutorOption.flowNameList = this.getFlowNameList();
        return flowExecutorOption;
    }

    private List<String> getFlowNameList() {
        ArrayList<String> flowNameList = new ArrayList<String>();
        if (null != this.flowExecutorRootConfig.tryCatchFinallyHandler) {
            flowNameList.add("handler-tryCatchFinally:" + this.flowExecutorRootConfig.tryCatchFinallyHandler.name());
        }
        if (null != this.flowExecutorRootConfig.beforeAfterFlowHandler) {
            flowNameList.add("handler-beforeAfter:" + this.flowExecutorRootConfig.beforeAfterFlowHandler.name());
        }
        for (BusinessFlow flow : this.flowExecutorRootConfig.flowList) {
            flowNameList.add(flow.name());
        }
        return flowNameList;
    }

    private void executeTryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler, String operation, Exception e) throws Exception {
        if (null == tryCatchFinallyHandler) {
            return;
        }
        switch (operation) {
            case "try": {
                tryCatchFinallyHandler.handleTry(this.flowExecutorRootConfig.flowContext);
                break;
            }
            case "catch": {
                tryCatchFinallyHandler.handleException(this.flowExecutorRootConfig.flowContext, e);
                break;
            }
            case "finally": {
                tryCatchFinallyHandler.handleFinally(this.flowExecutorRootConfig.flowContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5!\u65b9\u6cd5\u540d:" + operation);
            }
        }
    }

    private void executeBeforeAfterFlowHandler(BeforeAfterFlowHandler beforeAfterFlowHandler) throws Exception {
        List<BusinessFlow> afterFlowList;
        if (null == beforeAfterFlowHandler) {
            return;
        }
        List<BusinessFlow> beforeFlowList = beforeAfterFlowHandler.getBeforeFlowList();
        if (null != beforeFlowList && !beforeFlowList.isEmpty()) {
            this.flowExecutorRootConfig.flowList.addAll(0, beforeFlowList);
        }
        if (null != (afterFlowList = beforeAfterFlowHandler.getAfterFlowList()) && !afterFlowList.isEmpty()) {
            this.flowExecutorRootConfig.flowList.addAll(afterFlowList);
        }
    }
}

