/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FlowContextImpl
implements FlowContext {
    private FlowExecutorConfig flowExecutorConfig;

    public FlowContextImpl(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    @Override
    public Object checkData(String key) {
        Object value = this.getData(key);
        if (null == value) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return value;
    }

    @Override
    public Object getData(String key) {
        return this.flowExecutorConfig.dataMap.get(key);
    }

    @Override
    public Map<String, Object> getData() {
        return this.flowExecutorConfig.dataMap;
    }

    @Override
    public void putData(String key, Object value) {
        this.flowExecutorConfig.dataMap.put(key, value);
    }

    @Override
    public void putData(Map<String, Object> map) {
        this.flowExecutorConfig.dataMap.putAll(map);
    }

    @Override
    public void removeData(String key) {
        this.flowExecutorConfig.dataMap.remove(key);
    }

    @Override
    public void remark(String remark) {
        this.flowExecutorConfig.remarkBuilder.append("|" + remark);
    }

    @Override
    public void brokenCurrentFlow(String reason) {
        throw new BrokenCurrentFlowException(reason);
    }

    @Override
    public void broken(String reason) {
        throw new BrokenException(reason);
    }

    @Override
    public String getFlowName() {
        return this.flowExecutorConfig.name;
    }

    @Override
    public List<String> getFlowNameList() {
        return this.flowExecutorConfig.flowNameList;
    }

    @Override
    public String getFlowTrace() {
        return this.flowExecutorConfig.printTraceBuilder.toString();
    }

    @Override
    public Exception getFlowException() {
        return this.flowExecutorConfig.exception;
    }

    @Override
    public String getBrokenReason() {
        return this.flowExecutorConfig.brokenReason;
    }

    @Override
    public QuickFlowExecutor startSubFlow(String name) {
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        flowExecutorConfig.dataMap = this.flowExecutorConfig.dataMap;
        flowExecutorConfig.index = this.flowExecutorConfig.index;
        flowExecutorConfig.subflowLevel = this.flowExecutorConfig.subflowLevel + 1;
        flowExecutorConfig.flowNameList = this.flowExecutorConfig.flowNameList;
        flowExecutorConfig.parentFlowExecutorConfig = this.flowExecutorConfig;
        flowExecutorConfig.flowConfig = this.flowExecutorConfig.flowConfig;
        flowExecutorConfig.printTrace = this.flowExecutorConfig.printTrace;
        if (flowExecutorConfig.flowConfig.printTrace) {
            flowExecutorConfig.printTraceBuilder = this.flowExecutorConfig.printTraceBuilder;
        }
        return new QuickFlowExecutor(flowExecutorConfig);
    }
}

