/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContextImpl;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.listener.FlowNameInstanceMappingHandler;
import cn.schoolwow.quickflow.listener.QuickFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickFlow {
    private Logger logger = LoggerFactory.getLogger(QuickFlow.class);
    private FlowConfig flowConfig = new FlowConfig();
    private boolean build;

    public static QuickFlow newInstance() {
        return new QuickFlow();
    }

    public QuickFlow threadPool(ThreadPoolExecutor threadPoolExecutor) {
        this.flowConfig.threadPoolExecutor = threadPoolExecutor;
        return this;
    }

    public QuickFlow flowListener(QuickFlowListener quickFlowListener) {
        this.flowConfig.quickFlowListener = quickFlowListener;
        return this;
    }

    public QuickFlow printTrace(boolean printTrace) {
        this.flowConfig.printTrace = printTrace;
        return this;
    }

    public QuickFlow printConsumeTime(boolean printConsumeTime) {
        this.flowConfig.printConsumeTime = printConsumeTime;
        return this;
    }

    public QuickFlow flowNameInstanceMappingHandler(FlowNameInstanceMappingHandler flowNameInstanceMappingHandler) {
        this.flowConfig.flowNameInstanceMappingHandler = flowNameInstanceMappingHandler;
        return this;
    }

    public QuickFlow tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        this.flowConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    public QuickFlow build() {
        if (null == this.flowConfig.threadPoolExecutor) {
            this.flowConfig.threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        }
        this.build = true;
        return this;
    }

    public QuickFlowExecutor startFlow(String name) {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u4e3b\u6d41\u7a0b\u540d\u79f0!");
        }
        if (!this.build) {
            throw new UnsupportedOperationException("\u8bf7\u5148\u8c03\u7528build\u65b9\u6cd5!");
        }
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        flowExecutorConfig.dataMap = new ConcurrentHashMap<String, Object>();
        flowExecutorConfig.flowConfig = this.flowConfig;
        if (this.flowConfig.printTrace) {
            flowExecutorConfig.printTraceBuilder = new StringBuilder();
        }
        flowExecutorConfig.flowNameList = new ArrayList<String>();
        return new QuickFlowExecutor(flowExecutorConfig);
    }

    public QuickFlowExecutor startFlow(FlowExecutorOption flowExecutorOption) throws Exception {
        if (null == this.flowConfig.flowNameInstanceMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        if (null == flowExecutorOption.flowNameList || flowExecutorOption.flowNameList.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u6d41\u7a0b\u5217\u8868!");
        }
        QuickFlowExecutor quickFlowExecutor = this.startFlow(flowExecutorOption.name).putData(flowExecutorOption.dataMap);
        for (String flowName : flowExecutorOption.flowNameList) {
            if (flowName.startsWith("handler:")) {
                TryCatchFinallyHandler tryCatchFinallyHandler = this.flowConfig.flowNameInstanceMappingHandler.getTryCatchFinallyByName(flowName.substring(8));
                quickFlowExecutor.tryCatchFinallyHandler(tryCatchFinallyHandler);
                continue;
            }
            quickFlowExecutor.next(this.flowConfig.flowNameInstanceMappingHandler.getFlowByName(flowName));
        }
        return quickFlowExecutor;
    }
}

