package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;

import java.util.List;
import java.util.Map;

/**
 * 上下文对象
 */
public interface FlowContext {
    /**
     * 获取上下文数据,不存在时抛出异常
     */
    Object checkData(String key);

    /**
     * 获取上下文数据
     */
    Object getData(String key);

    /**
     * 获取上下文数据
     */
    Map<String,Object> getData();

    /**
     * 设置上下文数据
     */
    void putData(String key, Object value);

    /**
     * 设置上下文数据
     */
    void putData(Map<String, Object> map);

    /**
     * 移除上下文数据
     */
    void removeData(String key);

    /**
     * 流程备注
     */
    void remark(String remark);

    /**
     * 中断流程
     * @param reason 中断原因
     */
    void broken(String reason);

    /**
     * 获取主流程名
     */
    String getFlowName();

    /**
     * 获取流程列表
     */
    List<String> getFlowNameList();

    /**
     * 获取流程日志
     */
    String getFlowTrace();

    /**
     * 获取流程异常
     */
    Exception getFlowException();

    /**
     * 获取流程中断原因
     */
    String getBrokenReason();

    /**
     * 开启子流程
     */
    QuickFlowExecutor startSubFlow(String name);
}
