package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.exception.BrokenException;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FlowContextImpl implements FlowContext {
    /**
     * 配置数据
     */
    private FlowExecutorConfig flowExecutorConfig;

    public FlowContextImpl(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    @Override
    public Object checkData(String key) {
        Object value = getData(key);
        if(null==value){
            throw new IllegalArgumentException("上下文数据中key为"+key+"的值不能为空!");
        }
        if(value instanceof Collection){
            if(((Collection)value).isEmpty()){
                throw new IllegalArgumentException("上下文数据中key为"+key+"的列表不能为空!");
            }
        }
        return value;
    }

    @Override
    public Object getData(String key) {
        return flowExecutorConfig.dataMap.get(key);
    }

    @Override
    public Map<String, Object> getData() {
        return flowExecutorConfig.dataMap;
    }

    @Override
    public void putData(String key, Object value) {
        flowExecutorConfig.dataMap.put(key, value);
    }

    @Override
    public void putData(Map<String, Object> map) {
        flowExecutorConfig.dataMap.putAll(map);
    }

    @Override
    public void removeData(String key) {
        flowExecutorConfig.dataMap.remove(key);
    }

    @Override
    public void remark(String remark) {
        flowExecutorConfig.remarkBuilder.append("|"+remark);
    }

    @Override
    public void broken(String reason) {
        throw new BrokenException(reason);
    }

    @Override
    public String getFlowName() {
        return flowExecutorConfig.name;
    }

    @Override
    public List<String> getFlowNameList() {
        return flowExecutorConfig.flowNameList;
    }

    @Override
    public String getFlowTrace() {
        return flowExecutorConfig.printTraceBuilder.toString();
    }

    @Override
    public Exception getFlowException() {
        return flowExecutorConfig.exception;
    }

    @Override
    public String getBrokenReason() {
        return flowExecutorConfig.brokenReason;
    }

    @Override
    public QuickFlowExecutor startSubFlow(String name) {
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        flowExecutorConfig.dataMap = this.flowExecutorConfig.dataMap;
        flowExecutorConfig.index = this.flowExecutorConfig.index;
        flowExecutorConfig.subflowLevel = this.flowExecutorConfig.subflowLevel+1;
        flowExecutorConfig.flowNameList = this.flowExecutorConfig.flowNameList;
        flowExecutorConfig.parentFlowExecutorConfig = this.flowExecutorConfig;
        flowExecutorConfig.flowConfig = this.flowExecutorConfig.flowConfig;
        flowExecutorConfig.printTrace = this.flowExecutorConfig.printTrace;
        if(flowExecutorConfig.flowConfig.printTrace){
            flowExecutorConfig.printTraceBuilder = this.flowExecutorConfig.printTraceBuilder;
        }
        return new QuickFlowExecutor(flowExecutorConfig);
    }

}
