/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.AsyncBusinessFlow;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.ConditionFlow;
import cn.schoolwow.quickflow.flow.Flow;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickFlowExecutor {
    private Logger logger = LoggerFactory.getLogger(QuickFlowExecutor.class);
    private FlowExecutorConfig flowExecutorConfig;

    public QuickFlowExecutor(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    public Object checkData(String key) {
        return this.flowExecutorConfig.flowContext.checkData(key);
    }

    public Object getData(String key) {
        return this.flowExecutorConfig.flowContext.getData(key);
    }

    public QuickFlowExecutor putData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putData(key, value);
        return this;
    }

    public QuickFlowExecutor putData(Map<String, Object> dataMap) {
        this.flowExecutorConfig.flowContext.putData(dataMap);
        return this;
    }

    public QuickFlowExecutor next(String flowName) {
        if (null == this.flowExecutorConfig.flowConfig.flowNameInstanceMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        Flow flow = this.flowExecutorConfig.flowConfig.flowNameInstanceMappingHandler.getFlowByName(flowName);
        this.flowExecutorConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor next(Flow flow) {
        this.flowExecutorConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        this.flowExecutorConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    public QuickFlowExecutor execute() throws Exception {
        if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
            this.printFlowTrace(this.flowExecutorConfig.name);
        }
        if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
            if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.flowNameList.add("handler:" + this.flowExecutorConfig.tryCatchFinallyHandler.name());
            }
            for (Flow flow : this.flowExecutorConfig.flowList) {
                this.flowExecutorConfig.flowNameList.add(flow.name());
            }
        }
        try {
            if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.tryCatchFinallyHandler.handleTry(this.flowExecutorConfig.flowContext);
            }
            if (null == this.flowExecutorConfig.parentFlowExecutorConfig && null != this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler.handleTry(this.flowExecutorConfig.flowContext);
            }
            for (Flow flow : this.flowExecutorConfig.flowList) {
                if (null != this.flowExecutorConfig.flowConfig.quickFlowListener) {
                    this.flowExecutorConfig.flowConfig.quickFlowListener.beforeExecuteFlow(flow, this.flowExecutorConfig.flowContext);
                }
                this.executeFlow(flow);
                if (null == this.flowExecutorConfig.flowConfig.quickFlowListener) continue;
                this.flowExecutorConfig.flowConfig.quickFlowListener.afterExecuteFlow(flow, this.flowExecutorConfig.flowContext);
            }
        }
        catch (BrokenException e) {
            if (null != this.flowExecutorConfig.parentFlowExecutorConfig) {
                throw e;
            }
            this.printFlowTrace("[" + this.flowExecutorConfig.index++ + "]\u4e1a\u52a1\u6d41\u7a0b\u7ec8\u6b62|\u539f\u56e0:" + e.getReason());
            this.flowExecutorConfig.brokenReason = e.getReason();
        }
        catch (Exception e) {
            Flow currentFlow = this.flowExecutorConfig.flowList.get(this.flowExecutorConfig.index);
            this.printFlowTrace("[" + this.flowExecutorConfig.index++ + "]" + currentFlow.name() + "|\u4e1a\u52a1\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38|\u539f\u56e0:,\u5f02\u5e38\u539f\u56e0:" + e.getClass().getName() + "-" + e.getMessage());
            if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.tryCatchFinallyHandler.handleException(this.flowExecutorConfig.flowContext, e);
            }
            if (null == this.flowExecutorConfig.parentFlowExecutorConfig && null != this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler.handleException(this.flowExecutorConfig.flowContext, e);
            }
            if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
                this.flowExecutorConfig.exception = e;
            }
            throw e;
        }
        finally {
            if (null == this.flowExecutorConfig.parentFlowExecutorConfig && this.flowExecutorConfig.flowConfig.printTrace) {
                this.logger.info(this.flowExecutorConfig.printTraceBuilder.toString());
            }
            if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.tryCatchFinallyHandler.handleFinally(this.flowExecutorConfig.flowContext);
            }
            if (null == this.flowExecutorConfig.parentFlowExecutorConfig && null != this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler.handleFinally(this.flowExecutorConfig.flowContext);
            }
        }
        return this;
    }

    private void executeFlow(Flow flow) throws Exception {
        long startTime = System.currentTimeMillis();
        if (flow instanceof BusinessFlow) {
            ((BusinessFlow)flow).executeBusinessFlow(this.flowExecutorConfig.flowContext);
        } else if (flow instanceof AsyncBusinessFlow) {
            this.flowExecutorConfig.flowConfig.threadPoolExecutor.execute(() -> {
                try {
                    ((AsyncBusinessFlow)flow).asyncExecuteBusinessFlow(this.flowExecutorConfig.flowContext);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else if (flow instanceof ConditionFlow) {
            Flow conditionFlow = ((ConditionFlow)flow).judgeBusinessFlow(this.flowExecutorConfig.flowContext);
            if (conditionFlow.getClass().getName().equals(flow.getClass().getName())) {
                throw new IllegalArgumentException("\u53d1\u73b0\u5faa\u73af\u4e1a\u52a1\u903b\u8f91!\u5faa\u73af\u4e1a\u52a1\u7c7b:" + conditionFlow.getClass().getName());
            }
            this.executeFlow(conditionFlow);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b!" + flow.getClass().getName());
        }
        long endTime = System.currentTimeMillis();
        this.printFlowTrace("[" + this.flowExecutorConfig.index++ + "]" + (this.flowExecutorConfig.flowConfig.printConsumeTime ? "[" + (endTime - startTime) + "\u6beb\u79d2]" : "") + flow.name() + this.flowExecutorConfig.remarkBuilder.toString());
        this.flowExecutorConfig.remarkBuilder.setLength(0);
    }

    private void printFlowTrace(String content) {
        if (this.flowExecutorConfig.flowConfig.printTrace) {
            for (int i = 0; i < this.flowExecutorConfig.subflowLevel; ++i) {
                this.flowExecutorConfig.printTraceBuilder.append("\t|---");
            }
            this.flowExecutorConfig.printTraceBuilder.append(content + "\r\n");
        }
    }
}

