package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.flow.Flow;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FlowExecutorConfig {
    /**
     * 流程名称
     */
    public String name;

    /**
     * 父流程
     * */
    public FlowExecutorConfig parentFlowExecutorConfig;

    /**
     * 业务流程列表
     */
    public List<Flow> flowList = new ArrayList<>();

    /**
     * 上下文对象
     * */
    public FlowContext flowContext;

    /**
     * 流程备注记录
     */
    public StringBuilder remarkBuilder = new StringBuilder();

    /**
     * 上下文数据
     */
    public Map<String, Object> dataMap;

    /**
     * 打印流程列表
     */
    public List<String> flowNameList;

    /**
     * 打印执行路径
     */
    public StringBuilder printTraceBuilder;

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * 流程异常
     * */
    public Exception exception;

    /**
     * 中断原因
     * */
    public String brokenReason;

    /**
     * 流程下标
     */
    public int index = 0;

    /**
     * 子流程层级
     * */
    public int subflowLevel;

    /**
     * 全局流程配置
     * */
    public FlowConfig flowConfig;
}
