/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickFlowExecutor {
    private Logger logger = LoggerFactory.getLogger(QuickFlowExecutor.class);
    private FlowExecutorConfig flowExecutorConfig;

    public QuickFlowExecutor(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    public QuickFlowExecutor putData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putData(key, value);
        this.flowExecutorConfig.rootConfig.requestKeySet.add(key);
        return this;
    }

    public QuickFlowExecutor putData(Map<String, Object> dataMap) {
        this.flowExecutorConfig.flowContext.putData(dataMap);
        this.flowExecutorConfig.rootConfig.requestKeySet.addAll(dataMap.keySet());
        return this;
    }

    public QuickFlowExecutor putTemporaryData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putTemporaryData(key, value);
        this.flowExecutorConfig.rootConfig.requestKeySet.add(key);
        return this;
    }

    public QuickFlowExecutor putTemporaryData(Map<String, Object> dataMap) {
        this.flowExecutorConfig.flowContext.putTemporaryData(dataMap);
        this.flowExecutorConfig.rootConfig.requestKeySet.addAll(dataMap.keySet());
        return this;
    }

    public QuickFlowExecutor putThreadLocalData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putThreadLocalData(key, value);
        return this;
    }

    public QuickFlowExecutor putThreadLocalData(Map<String, Object> dataMap) {
        this.flowExecutorConfig.flowContext.putThreadLocalData(dataMap);
        return this;
    }

    public QuickFlowExecutor next(String flowName) {
        if (null == this.flowExecutorConfig.rootConfig.flowConfig.flowNameInstanceMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        BusinessFlow flow = this.flowExecutorConfig.rootConfig.flowConfig.flowNameInstanceMappingHandler.getFlowByName(flowName);
        this.flowExecutorConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor next(BusinessFlow flow) {
        this.flowExecutorConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        this.flowExecutorConfig.rootConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    public QuickFlowExecutor beforeAfterFlowHandler(BeforeAfterFlowHandler beforeAfterFlowHandler) {
        this.flowExecutorConfig.rootConfig.beforeAfterFlowHandler = beforeAfterFlowHandler;
        return this;
    }

    public QuickFlowExecutor printTrace(boolean printTrace) {
        this.flowExecutorConfig.rootConfig.printTrace = printTrace;
        return this;
    }

    public QuickFlowExecutor ignoreException(boolean ignoreException) {
        this.flowExecutorConfig.rootConfig.ignoreException = ignoreException;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowContext execute() throws Exception {
        block22: {
            BusinessFlow currentFlow = this.flowExecutorConfig.flowList.get(0);
            try {
                this.printFlowTrace("|---" + this.flowExecutorConfig.name);
                this.executeTryCatchFinallyHandler(this.flowExecutorConfig.rootConfig.tryCatchFinallyHandler, "try", null);
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
                    this.executeTryCatchFinallyHandler(this.flowExecutorConfig.rootConfig.flowConfig.tryCatchFinallyHandler, "try", null);
                    this.executeBeforeAfterFlowHandler(this.flowExecutorConfig.rootConfig.beforeAfterFlowHandler);
                    this.executeBeforeAfterFlowHandler(this.flowExecutorConfig.rootConfig.flowConfig.beforeAfterFlowHandler);
                    this.addFlowName();
                }
                Iterator<BusinessFlow> iterator = this.flowExecutorConfig.flowList.iterator();
                while (iterator.hasNext()) {
                    BusinessFlow flow;
                    currentFlow = flow = iterator.next();
                    if (null != this.flowExecutorConfig.rootConfig.flowConfig.quickFlowListener) {
                        this.flowExecutorConfig.rootConfig.flowConfig.quickFlowListener.beforeExecuteFlow(flow, this.flowExecutorConfig.flowContext);
                    }
                    long startTime = System.currentTimeMillis();
                    try {
                        flow.executeBusinessFlow(this.flowExecutorConfig.flowContext);
                        long endTime = System.currentTimeMillis();
                        this.printFlowTrace("[" + this.flowExecutorConfig.rootConfig.index.getAndIncrement() + "]" + (this.flowExecutorConfig.rootConfig.flowConfig.printConsumeTime ? "|" + (endTime - startTime) + "\u6beb\u79d2|" : "") + flow.name() + this.flowExecutorConfig.rootConfig.remarkBuilder.toString());
                    }
                    catch (BrokenCurrentFlowException e) {
                        long endTime = System.currentTimeMillis();
                        this.flowExecutorConfig.rootConfig.brokenReason = e.getReason();
                        this.printFlowTrace("[" + this.flowExecutorConfig.rootConfig.index.getAndIncrement() + "]" + (this.flowExecutorConfig.rootConfig.flowConfig.printConsumeTime ? "|" + (endTime - startTime) + "\u6beb\u79d2|" : "") + "|[x]|" + flow.name() + "|\u5f53\u524d\u6d41\u7a0b\u4e2d\u65ad|\u4e2d\u65ad\u539f\u56e0:" + e.getReason() + this.flowExecutorConfig.rootConfig.remarkBuilder.toString());
                    }
                    finally {
                        this.flowExecutorConfig.rootConfig.remarkBuilder.setLength(0);
                    }
                    if (null == this.flowExecutorConfig.rootConfig.flowConfig.quickFlowListener) continue;
                    this.flowExecutorConfig.rootConfig.flowConfig.quickFlowListener.afterExecuteFlow(flow, this.flowExecutorConfig.flowContext);
                }
            }
            catch (BrokenException e) {
                this.printFlowTrace("[" + this.flowExecutorConfig.rootConfig.index.getAndIncrement() + "]" + currentFlow.name() + this.flowExecutorConfig.rootConfig.remarkBuilder.toString());
                if (null != this.flowExecutorConfig.parentFlowExecutorConfig && !this.flowExecutorConfig.rootConfig.ignoreException) {
                    throw e;
                }
                this.printFlowTrace("[" + this.flowExecutorConfig.rootConfig.index.getAndIncrement() + "]|[x]|\u4e1a\u52a1\u6d41\u7a0b\u7ec8\u6b62|\u539f\u56e0:" + e.getReason());
                this.flowExecutorConfig.rootConfig.brokenReason = e.getReason();
                return this.flowExecutorConfig.rootConfig.brokenReason;
            }
            catch (Exception e) {
                this.printFlowTrace("[" + this.flowExecutorConfig.rootConfig.index.getAndIncrement() + "]|[x]|" + currentFlow.name() + "|\u4e1a\u52a1\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38|\u5f02\u5e38\u4fe1\u606f:" + e.getClass().getName() + "-" + e.getMessage());
                this.executeTryCatchFinallyHandler(this.flowExecutorConfig.rootConfig.tryCatchFinallyHandler, "catch", e);
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
                    this.executeTryCatchFinallyHandler(this.flowExecutorConfig.rootConfig.flowConfig.tryCatchFinallyHandler, "catch", e);
                }
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
                    this.flowExecutorConfig.rootConfig.exception = e;
                }
                if (!this.flowExecutorConfig.rootConfig.ignoreException) {
                    throw e;
                }
                e.printStackTrace();
            }
            finally {
                this.executeTryCatchFinallyHandler(this.flowExecutorConfig.rootConfig.tryCatchFinallyHandler, "finally", null);
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
                    this.executeTryCatchFinallyHandler(this.flowExecutorConfig.rootConfig.flowConfig.tryCatchFinallyHandler, "finally", null);
                }
                if (null != this.flowExecutorConfig.parentFlowExecutorConfig) break block22;
                Set<String> temporaryKeySet = this.flowExecutorConfig.rootConfig.temporaryKeySet;
                for (String temporaryKey : temporaryKeySet) {
                    this.flowExecutorConfig.rootConfig.dataMap.remove(temporaryKey);
                }
            }
        }
        return this.flowExecutorConfig.flowContext;
    }

    public QuickFlowExecutor save() {
        if (this.flowExecutorConfig.rootConfig.flowConfig.businessMap.containsKey(this.flowExecutorConfig.name)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u4fdd\u5b58\u8be5\u6d41\u7a0b!\u6d41\u7a0b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!\u6d41\u7a0b\u540d\u79f0:" + this.flowExecutorConfig.name);
        }
        BusinessFlow businessFlow = new BusinessFlow(){

            @Override
            public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                flowContext.putData(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.rootConfig.dataMap);
                QuickFlowExecutor quickFlowExecutor = flowContext.startSubFlow(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.name);
                if (null != ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.rootConfig.tryCatchFinallyHandler) {
                    quickFlowExecutor.tryCatchFinallyHandler(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.rootConfig.tryCatchFinallyHandler);
                }
                if (null != ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.rootConfig.beforeAfterFlowHandler) {
                    List<BusinessFlow> beforeFlowList = ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.rootConfig.beforeAfterFlowHandler.getBeforeFlowList();
                    Iterator<Object> iterator = beforeFlowList.iterator();
                    while (iterator.hasNext()) {
                        BusinessFlow beforeFlow = (BusinessFlow)iterator.next();
                        quickFlowExecutor.next(beforeFlow);
                    }
                }
                for (BusinessFlow flow : ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.flowList) {
                    quickFlowExecutor.next(flow);
                }
                if (null != ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.rootConfig.beforeAfterFlowHandler) {
                    List<BusinessFlow> afterFlowList = ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.rootConfig.beforeAfterFlowHandler.getAfterFlowList();
                    for (BusinessFlow afterFlow : afterFlowList) {
                        quickFlowExecutor.next(afterFlow);
                    }
                }
                quickFlowExecutor.execute();
            }

            @Override
            public String name() {
                return ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.name;
            }
        };
        this.flowExecutorConfig.rootConfig.flowConfig.businessMap.put(this.flowExecutorConfig.name, businessFlow);
        return this;
    }

    private void printFlowTrace(String content) {
        if (this.flowExecutorConfig.rootConfig.printTrace && this.flowExecutorConfig.rootConfig.flowConfig.printTrace) {
            for (int i = 0; i < this.flowExecutorConfig.subflowLevel; ++i) {
                this.flowExecutorConfig.rootConfig.printTraceBuilder.append("\t");
            }
            this.flowExecutorConfig.rootConfig.printTraceBuilder.append(content + "\r\n");
        }
    }

    private void addFlowName() {
        if (this.flowExecutorConfig.rootConfig.printTrace && this.flowExecutorConfig.rootConfig.flowConfig.printTrace) {
            if (null != this.flowExecutorConfig.rootConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.rootConfig.flowNameList.add("handler:" + this.flowExecutorConfig.rootConfig.tryCatchFinallyHandler.name());
            }
            for (BusinessFlow flow : this.flowExecutorConfig.flowList) {
                this.flowExecutorConfig.rootConfig.flowNameList.add(flow.name());
            }
        }
    }

    private void executeTryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler, String operation, Exception e) throws Exception {
        if (null == tryCatchFinallyHandler) {
            return;
        }
        switch (operation) {
            case "try": {
                tryCatchFinallyHandler.handleTry(this.flowExecutorConfig.flowContext);
                break;
            }
            case "catch": {
                tryCatchFinallyHandler.handleException(this.flowExecutorConfig.flowContext, e);
                break;
            }
            case "finally": {
                tryCatchFinallyHandler.handleFinally(this.flowExecutorConfig.flowContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5!\u65b9\u6cd5\u540d:" + operation);
            }
        }
    }

    private void executeBeforeAfterFlowHandler(BeforeAfterFlowHandler beforeAfterFlowHandler) throws Exception {
        List<BusinessFlow> afterFlowList;
        if (null == beforeAfterFlowHandler) {
            return;
        }
        List<BusinessFlow> beforeFlowList = beforeAfterFlowHandler.getBeforeFlowList();
        if (null != beforeFlowList && !beforeFlowList.isEmpty()) {
            this.flowExecutorConfig.flowList.addAll(0, beforeFlowList);
        }
        if (null != (afterFlowList = beforeAfterFlowHandler.getAfterFlowList()) && !afterFlowList.isEmpty()) {
            this.flowExecutorConfig.flowList.addAll(afterFlowList);
        }
    }
}

